/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;

public class PVInteger
extends PVStringParser {
    private int minValue;
    private int maxValue;

    public PVInteger() {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public PVInteger(int n) {
        this(n, Integer.MIN_VALUE);
    }

    public PVInteger(int n, int n2) {
        this.setBoundaries(n, n2);
    }

    public void setBoundaries(int n, int n2) {
        this.maxValue = Math.max(n, n2);
        this.minValue = Math.min(n, n2);
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return n <= this.getMaxValue() && this.getMinValue() <= n;
        }
        return false;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String error(Object object) {
        if (!(object instanceof Integer)) {
            return "Integer value expected.";
        }
        Integer n = (Integer)object;
        if (n < this.getMinValue()) {
            return "Expect an integer of minimal value: " + this.getMinValue();
        }
        if (n > this.getMaxValue()) {
            return "Expect an integer of maximal value: " + this.getMaxValue();
        }
        return "unchecked error";
    }

    @Override
    public Object parse(String string) throws PropertyParseException {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyParseException(numberFormatException.getMessage());
        }
    }
}

