/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;

public class PVCompoundAND
extends PVStringParser {
    private Set constituants = new HashSet();
    private List stringParsers = new ArrayList();

    public void add(PropertyVerifier propertyVerifier) {
        this.constituants.add(propertyVerifier);
        if (propertyVerifier instanceof PVStringParser) {
            this.stringParsers.add(propertyVerifier);
        }
    }

    public void remove(PropertyVerifier propertyVerifier) {
        if (this.constituants.remove(propertyVerifier) && propertyVerifier instanceof PVStringParser) {
            this.stringParsers.remove(propertyVerifier);
        }
    }

    @Override
    public Object parse(String string) throws PropertyParseException {
        for (PVStringParser pVStringParser : this.stringParsers) {
            if (!pVStringParser.acceptString(string)) continue;
            return pVStringParser.parse(string);
        }
        throw new PropertyParseException("No part can parse String");
    }

    @Override
    public boolean acceptString(String string) {
        for (PVStringParser pVStringParser : this.stringParsers) {
            if (!pVStringParser.acceptString(string)) continue;
            try {
                return this.accept(pVStringParser.parse(string));
            }
            catch (PropertyParseException propertyParseException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean accept(Object object) {
        for (PropertyVerifier propertyVerifier : this.constituants) {
            if (propertyVerifier.accept(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String error(Object object) {
        for (PropertyVerifier propertyVerifier : this.constituants) {
            if (propertyVerifier.accept(object)) continue;
            return propertyVerifier.getErrorMessage(object);
        }
        return "No parsers added to this AND verifier";
    }
}

