/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.placeholder;

import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.ide.editor.Editor;

public class DesignPartViewPlaceHolder
extends PlaceHolder {
    private DesignPartView dpv;

    public DesignPartViewPlaceHolder(DesignPart designPart) {
        super(designPart);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, String string) {
        super(designPart);
        this.setName(string);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, DesignPartView designPartView) {
        super(designPart);
        this.setObject(designPartView);
        this.dpv = designPartView;
        if (designPartView != null) {
            this.setObjectID(designPartView.getDPVId());
            designPartView.setPlaceHolder(this);
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    public void setDesignPartView(DesignPartView designPartView) {
        this.setObject(designPartView);
        this.dpv = designPartView;
        if (designPartView != null) {
            designPartView.setPlaceHolder(this);
            this.setObjectID(designPartView.getDPVId());
        }
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public String getName() {
        return this.dpv.getName();
    }

    @Override
    public boolean setName(String string) {
        if (!this.getName().equals(string)) {
            this.dpv.setName(string);
            if (this.containerSet != null) {
                this.containerSet.sort();
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        return true;
    }

    private void doSetVisible(boolean bl) {
        if (this.getDesignPartView().isMasterDPV()) {
            this.getDesignPartView().setVisible(bl);
            if (bl) {
                if (!this.getVisible()) {
                    Editor editor = DMDiagramEditor.openNewDiagram(this.getDesignPartView().getTabbedPane());
                    this.getDesignPartView().setContext(editor.getContext());
                } else {
                    this.getDesignPartView().activateEditor();
                }
            } else {
                this.getDesignPartView().closeEditor();
            }
        }
    }

    public void setVisible(final boolean bl, final boolean bl2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetVisible(bl);
            if (bl2) {
                this.setDirty(false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPartViewPlaceHolder.this.doSetVisible(bl);
                    if (bl2) {
                        DesignPartViewPlaceHolder.this.setDirty(false);
                    }
                }
            });
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(bl, false);
    }

    private void doSetVisible(boolean bl, ProgressDialog progressDialog) {
        if (this.getDesignPartView().isMasterDPV()) {
            if (bl) {
                if (!this.getVisible()) {
                    Editor editor = DMDiagramEditor.openNewDiagram(this.getDesignPartView().getTabbedPane());
                    this.getDesignPartView().setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(this.getDesignPartView().getController().getJToolBar());
                } else {
                    this.getDesignPartView().activateEditor();
                }
                this.getDesignPartView().setVisible(bl, progressDialog);
            } else {
                this.getDesignPartView().closeEditor();
            }
        }
    }

    public void setVisible(final boolean bl, final ProgressDialog progressDialog) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetVisible(bl, progressDialog);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPartViewPlaceHolder.this.doSetVisible(bl, progressDialog);
                }
            });
        }
    }

    public boolean getVisible() {
        if (this.getDesignPartView().isMasterDPV()) {
            return this.getDesignPartView().isEditorVisible();
        }
        return true;
    }

    @Override
    public String getObjectTypeName() {
        return "DesignPartViewPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("DesignPartViewPlaceHolder");
    }

    @Override
    public int getNumberOfChildren() {
        if (this.dpv.isMasterDPV()) {
            return this.dpv.getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        return this.dpv.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.dpv.getIndexForChild(modelObject);
    }

    @Override
    public boolean isLeaf() {
        if (this.dpv.isMasterDPV()) {
            return this.dpv.isLeaf();
        }
        return true;
    }

    @Override
    public Object getParent() {
        return this.getDesignObjectSet();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getAppView(), this);
            modelPropertiesDialogEx.initProperties(this);
            modelPropertiesDialogEx.show();
        }
    }

    public XtdMapping getDeletedMapping(String string) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string);
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    public DPVLogicalSubView getEngEntSubView(LogicalDesign logicalDesign) {
        DPVLogical dPVLogical;
        RepositoryObject repositoryObject;
        RepositoryObject repositoryObject2;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, logicalDesign.getObjectID());
        if (list.size() > 0 && (repositoryObject2 = (DesignPartViewPlaceHolder)((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null && (dPVLogical = (DPVLogical)repositoryObject2.getDesignPartView()) != null && dPVLogical instanceof DPVLogicalSubView) {
            return (DPVLogicalSubView)dPVLogical;
        }
        repositoryObject = (DesignPartViewPlaceHolder)logicalDesign.getLogicalDesignSubviews().getObjectByID(this.getGeneratorID());
        if (repositoryObject == null) {
            repositoryObject = (DesignPartViewPlaceHolder)logicalDesign.getLogicalDesignSubviews().getObjectGeneratedBy(this.getObjectID());
        }
        if (repositoryObject != null && ((DesignObject)repositoryObject).getDesignPart() == logicalDesign && (repositoryObject2 = (DPVLogical)((DesignPartViewPlaceHolder)repositoryObject).getDesignPartView()) != null && repositoryObject2 instanceof DPVLogicalSubView) {
            return (DPVLogicalSubView)repositoryObject2;
        }
        return null;
    }

    public DPVRelationalSubView getEngTabSubView(RelationalDesign relationalDesign) {
        DPVRelational dPVRelational;
        RepositoryObject repositoryObject;
        RepositoryObject repositoryObject2;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (repositoryObject2 = (DesignPartViewPlaceHolder)((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null && (dPVRelational = (DPVRelational)repositoryObject2.getDesignPartView()) != null && dPVRelational instanceof DPVRelationalSubView) {
            return (DPVRelationalSubView)dPVRelational;
        }
        repositoryObject = (DesignPartViewPlaceHolder)relationalDesign.getPhysicalDesignSubviews().getObjectByID(this.getGeneratorID());
        if (repositoryObject == null) {
            repositoryObject = (DesignPartViewPlaceHolder)relationalDesign.getPhysicalDesignSubviews().getObjectGeneratedBy(this.getObjectID());
        }
        if (repositoryObject == null) {
            repositoryObject = (DesignPartViewPlaceHolder)relationalDesign.getPhysicalDesignSubviews().getObjectByID(this.getDesignPartView().getGeneratorId());
        }
        if (repositoryObject != null && ((DesignObject)repositoryObject).getDesignPart() == relationalDesign && (repositoryObject2 = (DPVRelational)((DesignPartViewPlaceHolder)repositoryObject).getDesignPartView()) != null && repositoryObject2 instanceof DPVRelationalSubView) {
            return (DPVRelationalSubView)repositoryObject2;
        }
        return null;
    }

    @Override
    public String getObjectID() {
        if (this.dpv != null) {
            return this.dpv.getDPVId();
        }
        String string = super.getObjectID();
        this.setObjectID(string);
        return string;
    }

    @Override
    public boolean isCheckedOut() {
        if (this.dpv != null) {
            return this.dpv.isCheckedOut();
        }
        return super.isCheckedOut();
    }

    @Override
    public boolean isDirty() {
        if (this.dpv != null) {
            return this.dpv.isDirty() || super.isDirty();
        }
        return super.isDirty();
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.dpv != null && bl) {
            this.dpv.setDirty(bl);
        }
        super.setDirty(bl);
    }

    @Override
    public String getRepositoryOID() {
        if (this.dpv != null) {
            return this.dpv.getRepositoryOID();
        }
        return super.getRepositoryOID();
    }

    @Override
    public String getRepositoryOVID() {
        if (this.dpv != null) {
            return this.dpv.getRepositoryOVID();
        }
        return super.getRepositoryOVID();
    }

    @Override
    public String getFilePath() {
        if (this.dpv != null) {
            return this.dpv.getFilePath();
        }
        return super.getFilePath();
    }

    @Override
    public void setFilePath(String string) {
        if (this.dpv != null) {
            this.dpv.setFilePath(string);
        }
        super.setFilePath(string);
    }

    @Override
    public String getStorageName() {
        if (this.dpv != null) {
            return this.dpv.getStorageName();
        }
        return super.getStorageName();
    }
}

