/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.io.InputStream;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLModelIDObject;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenericRXMLStorageObject
extends AbstractRXMLModelIDObject {
    private Class baseClass = StorageObject.class;
    private Class wrappeeClass = StorageObject.class;
    private String relativePath = "";
    private AbstractRXMLStorageDesign storageDesignReader;
    private static final Logger LOGGER = new Logger(GenericRXMLStorageObject.class);

    public GenericRXMLStorageObject(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    public void setBaseClass(Class clazz) {
        this.baseClass = clazz;
    }

    public void setWrappeeClass(Class clazz) {
        if (!StorageObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("wrappee class should be a StorageObject subclass");
        }
        this.wrappeeClass = clazz;
    }

    protected Class getBaseClass() {
        return this.baseClass;
    }

    protected Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    public void setRelativePath(String string) {
        this.relativePath = string;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public String getRelativePath(Object object) {
        return this.getRelativePath((ReadRequest)object);
    }

    public String getRelativePath(ReadRequest readRequest) {
        StoragePathTranslator.WRITE_OPERATION = false;
        return StoragePathTranslator.getPath(readRequest.getStorageObject());
    }

    @Override
    public String getFilename(Object object) {
        return this.getFilename((ReadRequest)object);
    }

    public String getFilename(ReadRequest readRequest) {
        return readRequest.getObjectName();
    }

    @Override
    public boolean canRead(Object object) {
        if (object instanceof ReadRequest) {
            return this.canRead((ReadRequest)object);
        }
        if (object instanceof StorageObject) {
            return this.getWrappeeClass().isAssignableFrom(object.getClass());
        }
        return false;
    }

    public boolean canRead(ReadRequest readRequest) {
        if (readRequest.getStorageObject() == null) {
            return false;
        }
        return this.getWrappeeClass().isAssignableFrom(readRequest.getStorageObject().getClass());
    }

    @Override
    public Object recreateObject(Object object, Design design, boolean bl) {
        design.getAppView().setCurrentDesign(design);
        ReadRequest readRequest = (ReadRequest)object;
        InputStream inputStream = this.getInputStreamFor(object);
        if (inputStream != null) {
            try {
                Document document = GenericRXMLStorageObject.parse(inputStream, this.getFilename(object), design);
                boolean bl2 = false;
                if (document == null) {
                    LOGGER.error("doc null for id/name: <" + object + ">");
                    return null;
                }
                Object object2 = this.recreateObject(document, readRequest, bl2);
                return object2;
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("Error recreating StorageObject from XML: *****  id/name: <" + object + "> *****");
                return null;
            }
        }
        return null;
    }

    public Object recreateObject(Document document, ReadRequest readRequest, boolean bl) {
        StoragePathTranslator.WRITE_OPERATION = false;
        Element element = document.getDocumentElement();
        Element element2 = GenericRXMLStorageObject.getFirstChildByTagName(element, "object");
        StorageObject storageObject = readRequest.getStorageObject();
        this.readBasicObjectInfo(element2, storageObject, bl);
        Element element3 = GenericRXMLStorageObject.getFirstChildByTagName(element, "properties");
        if (element3 == null) {
            element3 = GenericRXMLStorageObject.getFirstChildByTagName(element2, "properties");
        }
        this.readWrappedProperties(element3, storageObject);
        this.readObjectInfo(element2, storageObject, bl);
        storageObject.setPersisted(true);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(StoragePathTranslator.getPath(storageObject)).append('/').append(storageObject.getObjectID()).append(".dmd");
        storageObject.setFilePath(stringBuffer.toString());
        StorageDesign storageDesign = storageObject.getStorageDesign();
        String string = storageObject.getObjectTypeName();
        if (storageDesign.getLoadedVersion() > 2.1f && "Table".equalsIgnoreCase(string) && storageObject instanceof TableProxy) {
            this.readTableElements((TableProxy)storageObject, element, storageDesign);
            this.readSAC_StorageObjects((TableProxy)storageObject, element, storageDesign);
        }
        storageObject.setDirty(false);
        return storageObject;
    }

    private void readTableElements(TableProxy tableProxy, Element element, StorageDesign storageDesign) {
        int n;
        Object object;
        int n2;
        Element element2 = GenericRXMLStorageObject.getFirstChildByTagName(element, "columns");
        if (element2 != null && (n2 = (object = element2.getElementsByTagName("Column")).getLength()) > 0) {
            for (n = 0; n < n2; ++n) {
                Element element3 = (Element)object.item(n);
                this.recreateContainedStorageObject(element3, storageDesign, tableProxy, false);
            }
        }
        if ((object = GenericRXMLStorageObject.getFirstChildByTagName(element, "keys_and_indexes")) != null) {
            Element element4;
            NodeList nodeList = object.getElementsByTagName("PrimaryKey");
            n = nodeList.getLength();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    element4 = (Element)nodeList.item(i);
                    this.recreateContainedStorageObject(element4, storageDesign, tableProxy, false);
                }
            }
            if ((n = (nodeList = object.getElementsByTagName("Unique")).getLength()) > 0) {
                for (int i = 0; i < n; ++i) {
                    element4 = (Element)nodeList.item(i);
                    this.recreateContainedStorageObject(element4, storageDesign, tableProxy, false);
                }
            }
            if ((n = (nodeList = object.getElementsByTagName("Index")).getLength()) > 0) {
                for (int i = 0; i < n; ++i) {
                    element4 = (Element)nodeList.item(i);
                    this.recreateContainedStorageObject(element4, storageDesign, tableProxy, false);
                }
            }
            if ((n = (nodeList = object.getElementsByTagName("ForeignKey")).getLength()) > 0) {
                for (int i = 0; i < n; ++i) {
                    element4 = (Element)nodeList.item(i);
                    this.recreateContainedStorageObject(element4, storageDesign, tableProxy, false);
                }
            }
        }
    }

    private void readSAC_StorageObjects(TableProxy tableProxy, Element element, StorageDesign storageDesign) {
        NodeList nodeList;
        int n;
        Element element2 = GenericRXMLStorageObject.getFirstChildByTagName(element, "storage_objects");
        if (element2 != null && (n = (nodeList = element2.getElementsByTagName("storage_object")).getLength()) > 0) {
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                this.recreateSACStorageObject(element3, storageDesign, tableProxy, false);
            }
        }
    }

    public Object recreateObject(Document document, ReadRequest readRequest, StorageDesign storageDesign, boolean bl) {
        StoragePathTranslator.WRITE_OPERATION = false;
        Element element = document.getDocumentElement();
        StorageObject storageObject = null;
        Element element2 = GenericRXMLStorageObject.getFirstChildByTagName(document.getDocumentElement(), "object");
        storageObject = readRequest.getStorageObject();
        this.readBasicObjectInfo(element2, storageObject, bl);
        Element element3 = GenericRXMLStorageObject.getFirstChildByTagName(document.getDocumentElement(), "properties");
        if (element3 == null) {
            element3 = GenericRXMLStorageObject.getFirstChildByTagName(element2, "properties");
        }
        this.readWrappedProperties(element3, storageObject);
        this.readObjectInfo(element2, storageObject, bl);
        storageObject.setPersisted(true);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(StoragePathTranslator.getPath(storageObject)).append('/').append(storageObject.getObjectID()).append(".dmd");
        storageObject.setFilePath(stringBuffer.toString());
        String string = storageObject.getObjectTypeName();
        if (storageDesign.getLoadedVersion() > 2.1f && "Table".equalsIgnoreCase(string) && storageObject instanceof TableProxy) {
            this.readTableElements((TableProxy)storageObject, element, storageDesign);
            this.readSAC_StorageObjects((TableProxy)storageObject, element, storageDesign);
        }
        storageObject.setDirty(false);
        return storageObject;
    }

    public Object recreateObjectContainedProxy(Element element, StorageObject storageObject, StorageDesign storageDesign, boolean bl) {
        this.readBasicObjectInfo(element, storageObject, bl);
        Element element2 = GenericRXMLStorageObject.getFirstChildByTagName(element, "properties");
        this.readWrappedProperties(element2, storageObject);
        this.readObjectInfo(element, storageObject, bl);
        storageObject.setPersisted(true);
        storageObject.setDirty(false);
        return storageObject;
    }

    public StorageObject recreateContainedStorageObject(Element element, StorageDesign storageDesign, StorageObject storageObject, boolean bl) {
        StorageObject storageObject2 = null;
        storageDesign.setInitialReadBackDone(true);
        String string = element.getAttribute("id");
        if (string != null) {
            Object object;
            Object object2;
            storageObject2 = storageDesign.getStorageObject(string);
            if (storageObject2 == null) {
                String string2 = null;
                object2 = storageDesign.getCorrespondenceMap();
                if (object2 != null && (object = (ModelIDObject)object2.get(string)) != null) {
                    string2 = ((ModelIDObject)object).getObjectID();
                    storageObject2 = storageDesign.getStorageObject(string2);
                }
            }
            if (storageObject2 != null) {
                boolean bl2 = true;
                if (storageObject2 instanceof RelationalObjectProxy && (object2 = ((RelationalObjectProxy)storageObject2).getObject()) != null) {
                    bl2 = ((ModelIDObject)object2).shouldBeMerge();
                }
                if (bl2) {
                    object2 = this.getStorageDesignReader();
                    if (!this.isNestedObject(storageObject2) && object2 != null && (object = ((AbstractRXMLStorageDesign)object2).getReaderForContainedProxy(storageObject2)) instanceof GenericRXMLStorageObject) {
                        ((GenericRXMLStorageObject)object).recreateObjectContainedProxy(element, storageObject2, storageDesign, bl);
                    }
                }
                storageObject2.setPAC_Element(storageObject);
            }
        }
        return storageObject2;
    }

    public StorageObject recreateSACStorageObject(Element element, StorageDesign storageDesign, StorageObject storageObject, boolean bl) {
        ModelIDObject modelIDObject = null;
        storageDesign.setInitialReadBackDone(true);
        String string = element.getAttribute("id");
        if (string != null) {
            String string2 = element.getAttribute("type");
            AbstractRXMLStorageDesign abstractRXMLStorageDesign = this.getStorageDesignReader();
            if (abstractRXMLStorageDesign != null) {
                modelIDObject = abstractRXMLStorageDesign.recreateStorageObject(element, string2, storageDesign, bl);
            }
            if (modelIDObject != null) {
                modelIDObject.setPAC_Element(storageObject);
            }
        }
        return modelIDObject;
    }

    private boolean isNestedObject(StorageObject storageObject) {
        if (storageObject instanceof ColumnProxy) {
            Column column = (Column)((ColumnProxy)storageObject).getObject();
            return column.isNested();
        }
        return false;
    }

    protected void readWrappedProperties(Element element, StorageObject storageObject) {
        PropertyMapWrapper propertyMapWrapper = this.getPropertyMapWrapper(storageObject);
        propertyMapWrapper.setTranslators(storageObject.getStorageDesign().getPropertyTranslators());
        this.readPropertiesList(element, propertyMapWrapper, storageObject);
        this.releasePropertyMapWrapper(propertyMapWrapper);
        StorageDesign storageDesign = storageObject.getStorageDesign();
        if (storageDesign.getDesign().isMerging() || storageDesign.isCloneOperation()) {
            storageObject.setOwnerDesignName(storageDesign.getDesign().getName());
        }
    }

    protected PropertyMapWrapper getPropertyMapWrapper(StorageObject storageObject) {
        return this.getPMWPoolMap().getInstance(this.getWrappeeClass(), this.getBaseClass(), storageObject);
    }

    protected void releasePropertyMapWrapper(PropertyMapWrapper propertyMapWrapper) {
        if (propertyMapWrapper instanceof PMWPooled) {
            ((PMWPooled)propertyMapWrapper).releaseFromPool();
        } else {
            LOGGER.error("releasePropertyMapWrapper: can not release");
        }
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        throw new RuntimeException("Replaced with call to recreateObject(Document, ReadRequest, boolean).");
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == StorageObject.class;
    }

    public AbstractRXMLStorageDesign getStorageDesignReader() {
        return this.storageDesignReader;
    }

    public void setStorageDesignReader(AbstractRXMLStorageDesign abstractRXMLStorageDesign) {
        this.storageDesignReader = abstractRXMLStorageDesign;
    }
}

