/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.ReadRequestStorageDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.storage.GenericRXMLStorageObject;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractRXMLStorageDesign
extends AbstractXMLReader {
    private GenericRXMLStorageObject first = null;
    private static final Logger LOGGER = new Logger(AbstractRXMLStorageDesign.class);

    public AbstractRXMLStorageDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        throw new IllegalStateException("StorageDesigns do not have fixed paths. getRelativePath(Object) should have been called");
    }

    public abstract RDBMSType getRDBMSType();

    public void insert(GenericRXMLStorageObject genericRXMLStorageObject) {
        genericRXMLStorageObject.setSuccessor(this.first);
        this.first = genericRXMLStorageObject;
        genericRXMLStorageObject.setStorageDesignReader(this);
    }

    @Override
    public boolean canRead(Object object) {
        if (object instanceof ReadRequest) {
            ReadRequest readRequest = (ReadRequest)object;
            boolean bl = readRequest.isRequestFor(this.getRDBMSType());
            if (bl) {
                boolean bl2 = this.first.getReaderFor(object) != null;
                return bl2;
            }
        } else {
            if (object instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)object;
                return storageDesign.getRDBMSType().equals(this.getRDBMSType());
            }
            if (object instanceof ReadRequestStorageDesign) {
                ReadRequestStorageDesign readRequestStorageDesign = (ReadRequestStorageDesign)object;
                boolean bl = readRequestStorageDesign.isRequestFor(this.getRDBMSType());
                return bl;
            }
        }
        return false;
    }

    @Override
    public Object recreateObject(Object object, Design design, boolean bl) {
        if (object instanceof ReadRequest) {
            Object object2;
            AbstractXMLReader abstractXMLReader = this.first.getReaderFor(object);
            if (abstractXMLReader != null && (object2 = abstractXMLReader.recreateObject(object, design, bl)) != null && object2 instanceof ModelIDObject) {
                ModelIDObject modelIDObject = (ModelIDObject)object2;
                if (!modelIDObject.belongsToDesign()) {
                    modelIDObject.setReadOnly(true);
                }
                return modelIDObject;
            }
        } else {
            if (object instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)object;
                if (this.getPersistenceManager().exists(this.getRelativePath(storageDesign), storageDesign.getFileName())) {
                    return this.recreateObject(storageDesign, bl);
                }
                return storageDesign;
            }
            if (object instanceof ReadRequestStorageDesign) {
                ReadRequestStorageDesign readRequestStorageDesign = (ReadRequestStorageDesign)object;
                StorageDesign storageDesign = readRequestStorageDesign.getStorageDesign();
                String string = readRequestStorageDesign.getDesignName();
                if (this.getPersistenceManager().exists(this.getRelativePath(storageDesign), string)) {
                    return this.recreateObject(storageDesign, string, bl && readRequestStorageDesign.getRequestLock());
                }
                return storageDesign;
            }
        }
        return null;
    }

    public Object recreateObject(StorageDesign storageDesign, boolean bl) {
        return this.recreateObject(storageDesign, storageDesign.getFileName(), bl);
    }

    public Object recreateObject(StorageDesign storageDesign, String string, boolean bl) {
        String string2 = this.getRelativePath(storageDesign);
        String string3 = string;
        InputStream inputStream = this.getPersistenceManager().getInputStreamFor(string2, string3);
        if (inputStream != null) {
            try {
                Design design = storageDesign != null ? storageDesign.getDesign() : null;
                Document document = AbstractRXMLStorageDesign.parse(inputStream, string3, design);
                boolean bl2 = false;
                this.recreateStorageDesign(document, storageDesign, bl2);
                return storageDesign;
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("Error recreating StorageDesign object from XML: " + throwable);
            }
        }
        return null;
    }

    public void recreateStorageDesign(Document document, StorageDesign storageDesign, boolean bl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("rep_oid");
        if (!"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
            storageDesign.setRepositoryOID(string2);
        }
        if (!"".equalsIgnoreCase(string2 = element.getAttribute("rep_ovid")) && !"null".equalsIgnoreCase(string2)) {
            storageDesign.setRepositoryOVID(string2);
        }
        float f = 2.1f;
        string2 = element.getAttribute("stdes_version");
        if (!"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
            try {
                f = Float.valueOf(string2).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        storageDesign.setLoadedVersion(f);
        if (f <= 2.1f) {
            this.recreateRequests(storageDesign);
        }
        NodeList nodeList = element.getElementsByTagName("object");
        ArrayList<ReadRequest> arrayList = new ArrayList<ReadRequest>();
        storageDesign.setInitialReadBackDone(true);
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            object4 = (Element)nodeList.item(n);
            object3 = object4.getAttribute("oid");
            object2 = object4.getAttribute("type");
            object = object4.getAttribute("role");
            string = object4.getAttribute("marked_generate");
            treeMap.put(object3, string);
            StorageObjectSet storageObjectSet = storageDesign.getStorageObjectSetForType((String)object2);
            if (storageObjectSet != null) {
                ReadRequest readRequest = storageDesign.getReadRequestFor((String)object3);
                readRequest.setObjectSet(storageObjectSet);
                readRequest.setRequestLock("contains".equals(object));
                readRequest.getStorageObject();
                arrayList.add(readRequest);
                continue;
            }
            if (!storageDesign.isCloneOperation()) continue;
            storageDesign.getReadRequestFor((String)object3);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object4 = (ReadRequest)arrayList.get(n);
            this.recreateObject(object4, storageDesign.getDesign(), ((ReadRequest)object4).getRequestLock());
            object3 = ((ReadRequest)object4).getStorageObject();
            object2 = (String)treeMap.get(((ModelIDObject)object3).getObjectID());
            if (object2 != null) {
                if ("true".equalsIgnoreCase((String)object2) || "".equalsIgnoreCase((String)object2)) {
                    ((StorageObject)object3).setMarkedGenerate(true);
                } else {
                    ((StorageObject)object3).setMarkedGenerate(false);
                }
            } else {
                ((StorageObject)object3).setMarkedGenerate(true);
            }
            if (storageDesign.isCloneOperation()) {
                ((StorageObject)object3).setDirty(true);
            }
            storageDesign.removeReadRequestFor((ReadRequest)object4);
        }
        ReadRequest[] readRequestArray = storageDesign.getReadRequests();
        int n3 = 0;
        for (int i = 0; i < readRequestArray.length; ++i) {
            object2 = readRequestArray[i];
            object = ((ReadRequest)object2).getStorageObject();
            if (object instanceof ColumnProxy) {
                ++n3;
                if (!this.isNestedObject((ReadRequest)object2)) {
                    this.recreateObject(object2, storageDesign.getDesign(), ((ReadRequest)object2).getRequestLock());
                }
            } else {
                string = (String)treeMap.get(((ModelIDObject)object).getObjectID());
                if (f <= 2.1f) {
                    this.recreateObject(object2, storageDesign.getDesign(), ((ReadRequest)object2).getRequestLock());
                } else if (string != null) {
                    this.recreateObject(object2, storageDesign.getDesign(), ((ReadRequest)object2).getRequestLock());
                }
                if (string != null) {
                    if ("true".equalsIgnoreCase(string) || "".equalsIgnoreCase(string)) {
                        ((StorageObject)object).setMarkedGenerate(true);
                    } else {
                        ((StorageObject)object).setMarkedGenerate(false);
                    }
                } else {
                    ((StorageObject)object).setMarkedGenerate(true);
                }
            }
            if (storageDesign.isCloneOperation()) {
                ((StorageObject)object).setDirty(true);
            }
            storageDesign.removeReadRequestFor((ReadRequest)object2);
        }
        if (storageDesign.isCloneOperation()) {
            storageDesign.setDirty(true);
        }
        System.out.println(n3);
    }

    private void recreateRequests(StorageDesign storageDesign) {
        if (storageDesign.getColumnProxySet() != null) {
            this.recreateRequestsForSet(storageDesign, storageDesign.getColumnProxySet().iterator());
        }
        if (storageDesign.getIndexProxySet() != null) {
            this.recreateRequestsForSet(storageDesign, storageDesign.getIndexProxySet().iterator());
        }
        this.recreateRequestsForSet(storageDesign, storageDesign.getPKProxyList().iterator());
        this.recreateRequestsForSet(storageDesign, storageDesign.getUniqueList().iterator());
        this.recreateRequestsForSet(storageDesign, storageDesign.getFKProxyList().iterator());
    }

    private void recreateRequestsForSet(StorageDesign storageDesign, Iterator iterator) {
        while (iterator.hasNext()) {
            RelationalObjectProxy relationalObjectProxy = (RelationalObjectProxy)iterator.next();
            ReadRequest readRequest = storageDesign.getReadRequestFor(relationalObjectProxy.getObjectID());
            readRequest.setStorageObject(relationalObjectProxy);
        }
    }

    public StorageObject recreateStorageObject(Document document, String string, StorageDesign storageDesign, boolean bl) {
        StorageObject storageObject = null;
        Element element = document.getDocumentElement();
        storageDesign.setInitialReadBackDone(true);
        Element element2 = AbstractRXMLStorageDesign.getFirstChildByTagName(element, "object");
        String string2 = element2.getAttribute("id");
        if (string2 != null) {
            Object object;
            Object object2;
            String string3 = null;
            Map map = storageDesign.getCorrespondenceMap();
            if (map != null && (object2 = (ModelIDObject)map.get(string2)) != null) {
                string3 = ((ModelIDObject)object2).getObjectID();
            }
            if (string3 != null) {
                object2 = storageDesign.getReadRequestFor(string3);
                storageObject = storageDesign.getStorageObject(string3);
            } else {
                object2 = storageDesign.getReadRequestFor(string2);
                storageObject = storageDesign.getStorageObject(string2);
            }
            if (!((ReadRequest)object2).hasObjectSet()) {
                object = storageDesign.getStorageObjectSetForType(string);
                if (object == null && storageObject != null && storageObject instanceof RelationalObjectProxy) {
                    RelationalObjectProxySet relationalObjectProxySet = ((RelationalObjectProxy)storageObject).getProxySet();
                    ((ReadRequest)object2).setStorageObject(storageObject);
                    ((ReadRequest)object2).setObjectSet(relationalObjectProxySet);
                }
                if (object != null) {
                    ((ReadRequest)object2).setObjectSet(object);
                }
            }
            ((ReadRequest)object2).setRequestLock(true);
            storageObject = ((ReadRequest)object2).getStorageObject();
            if (storageObject != null && !this.isNestedObject((ReadRequest)object2) && (object = this.first.getReaderFor(object2)) instanceof GenericRXMLStorageObject) {
                ((GenericRXMLStorageObject)object).recreateObject(document, (ReadRequest)object2, storageDesign, bl);
            }
            storageObject = ((ReadRequest)object2).getStorageObject();
            storageDesign.removeReadRequestFor((ReadRequest)object2);
        }
        return storageObject;
    }

    public StorageObject recreateStorageObject(Element element, String string, StorageDesign storageDesign, boolean bl) {
        StorageObject storageObject = null;
        String string2 = element.getAttribute("id");
        if (string2 != null) {
            Object object;
            ReadRequest readRequest = storageDesign.getReadRequestFor(string2);
            if (!readRequest.hasObjectSet() && (object = storageDesign.getStorageObjectSetForType(string)) != null) {
                readRequest.setObjectSet(object);
            }
            readRequest.setRequestLock(true);
            storageObject = readRequest.getStorageObject();
            if (!this.isNestedObject(readRequest) && (object = this.first.getReaderFor(readRequest)) instanceof GenericRXMLStorageObject) {
                ((GenericRXMLStorageObject)object).recreateObjectContainedProxy(element, storageObject, storageDesign, bl);
            }
            storageObject = readRequest.getStorageObject();
            storageDesign.removeReadRequestFor(readRequest);
        }
        return storageObject;
    }

    public AbstractXMLReader getReaderFor(ReadRequest readRequest) {
        if (this.first != null) {
            return this.first.getReaderFor(readRequest);
        }
        return null;
    }

    public AbstractXMLReader getReaderForContainedProxy(StorageObject storageObject) {
        if (this.first != null) {
            return this.first.getReaderFor(storageObject);
        }
        return null;
    }

    private boolean isNestedObject(ReadRequest readRequest) {
        StorageObject storageObject = readRequest.getStorageObject();
        if (storageObject instanceof ColumnProxy) {
            Column column = (Column)((ColumnProxy)storageObject).getObject();
            return column.isNested();
        }
        return false;
    }

    @Override
    public String getRelativePath(Object object) {
        StoragePathTranslator.WRITE_OPERATION = false;
        return StoragePathTranslator.getPath((StorageDesign)object);
    }
}

