/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.standalone_domains;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadStAlDomains
implements XMLConstants {
    private static final Logger LOGGER = new Logger(ReadStAlDomains.class);
    private static final String domainFileRootNodeName = "DomainFile";
    private static final String oldDomainFileRootNodeName = "domain";
    private List domainList = new ArrayList();
    private DomainSet domainSet;
    private Design design;
    private Design targetDesgn;

    public ReadStAlDomains(ApplicationView applicationView, RDBMSSite rDBMSSite, Design design) {
        this.design = new Design(applicationView);
        this.targetDesgn = design;
        if (rDBMSSite != null) {
            this.design.getRelationalDesign().setSelectedRDBMSSite(rDBMSSite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readDomains(File file) {
        block25: {
            BufferedReader bufferedReader = null;
            this.domainList.clear();
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                    InputSource inputSource = new InputSource(bufferedReader);
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = null;
                    try {
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        // empty catch block
                    }
                    if (documentBuilder == null) break block25;
                    try {
                        Document document = documentBuilder.parse(inputSource);
                        Element element = document.getDocumentElement();
                        if (!element.getNodeName().equals(domainFileRootNodeName) && !element.getNodeName().equals(oldDomainFileRootNodeName)) {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            List list = this.domainList;
                            return list;
                        }
                        this.recreateDomains(document, this.design, false);
                    }
                    catch (SAXException sAXException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return this.domainList;
    }

    public void checkAndSetIDGenerator(List list) {
        Iterator iterator = list.iterator();
        long l = 0L;
        long l2 = 0L;
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            String string = modelIDObject.getObjectID();
            if (string.indexOf(64) <= -1 || (l2 = DesignPart.getCounter(string)) <= l) continue;
            l = l2;
        }
        long l3 = this.design.getAppView().getIDGenerator().getStartCounter();
        long l4 = this.design.getAppView().getIDGenerator().getLastIDIndex();
        if (l > l4) {
            this.design.getAppView().getIDGenerator().setCounter(l - l3 + 1L);
        }
    }

    private void recreateDomains(Document document, Design design, boolean bl) {
        Element element = document.getDocumentElement();
        String string = element.getTagName();
        if (string.equals(oldDomainFileRootNodeName)) {
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("object");
            int n = nodeList.getLength();
            Element element2 = null;
            for (int i = 0; i < n; ++i) {
                element2 = (Element)nodeList.item(i);
                if (!"Domain".equals(element2.getAttribute("type"))) continue;
                Domain domain = this.recreateDomain(element2, design, bl);
                this.domainList.add(domain);
            }
        } else {
            DomainFileWrapper domainFileWrapper = new DomainFileWrapper(this.targetDesgn, this.targetDesgn.getFileName(), this.getDomainSet());
            ApplicationView.getInstance().getXMLTransformationManager().transformFromXMLToObject(domainFileWrapper, document);
            this.domainList.addAll(domainFileWrapper.getDomains());
        }
        if (this.domainSet.size() > this.domainList.size()) {
            this.domainSet.remove(this.domainSet.getByName("Unknown"));
        }
    }

    public Domain recreateDomain(Element element, Design design, boolean bl) {
        String string;
        String string2 = element.getAttribute("id");
        Domain domain = null;
        if (domain == null) {
            domain = (Domain)this.instantiateDesignObject(string2);
        }
        if ((string = element.getAttribute("imported_id")) != null && !"".equalsIgnoreCase(string)) {
            domain.setImportedId(string);
        }
        this.readBasicObjectInfo(element, domain, bl);
        this.readObjectInfo(element, domain, bl);
        this.readAVT(element, domain);
        this.readConstraint(element, domain);
        Element element2 = ReadStAlDomains.getFirstChildByTagName(element, "logicaltype");
        String string3 = element2.getAttribute("oid");
        String string4 = element2.getAttribute("name");
        LogicalDatatype logicalDatatype = LogicalDatatype.getLogicalDatatype(this.getTargetDesgn(), string4, string3);
        this.readDataTypeParameters(element, domain);
        domain.setLogicalDatatype(logicalDatatype);
        String string5 = element.getAttribute("file");
        if (string5 != null && !"".equals(string5)) {
            domain.setFileName(string5);
        }
        return domain;
    }

    protected void readBasicObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        this.readBasicObjectInfo_0(element, modelIDObject, bl);
        NodeList nodeList = element.getElementsByTagName("engineering");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (((DesignObject)modelIDObject).getDesignPart() instanceof LogicalDesign) {
                NodeList nodeList2 = element.getElementsByTagName("relational_design");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element3 = (Element)nodeList2.item(i);
                    String string = element3.getAttribute("id");
                    boolean bl2 = Boolean.valueOf(element3.getAttribute("should"));
                    ((DesignObject)modelIDObject).setEngineerTo(string, bl2);
                }
            } else {
                String string = element2.getAttribute("should");
                if (string != null && string.equals(VALUE_TRUE)) {
                    modelIDObject.setShouldEngineer(true);
                } else {
                    modelIDObject.setShouldEngineer(false);
                }
            }
        }
    }

    protected void readBasicObjectInfo_0(Element element, ModelIDObject modelIDObject, boolean bl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Node node;
        Object object4;
        Element element2 = ReadStAlDomains.getFirstChildByTagName(element, "name");
        if (element2 != null && element2.getFirstChild() != null) {
            object4 = element2.getFirstChild().getNodeValue();
            modelIDObject.setName(StringUtilities.decodeAttributeValue((String)object4));
        }
        object4 = element.getElementsByTagName("alter");
        int n = object4.getLength();
        for (int i = 0; i < n; ++i) {
            node = (Element)object4.item(i);
            if (!node.getParentNode().equals(element)) continue;
            object3 = node.getAttribute("type");
            this.readChange((Element)node, modelIDObject, (String)object3);
        }
        Element element3 = ReadStAlDomains.getFirstChildByTagName(element, "comment");
        if (element3 != null && (node = element3.getFirstChild()) != null && (object3 = node.getNodeValue()) != null) {
            modelIDObject.setComment(StringUtilities.decodeAttributeValue((String)object3));
        }
        if ((node = ReadStAlDomains.getFirstChildByTagName(element, "notes")) != null && (object3 = node.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
            modelIDObject.setNotes(StringUtilities.decodeAttributeValue((String)object2));
        }
        if ((object3 = ReadStAlDomains.getFirstChildByTagName(element, "generator")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
            modelIDObject.setGeneratorID((String)object);
        }
        if (modelIDObject instanceof DesignObject && (object2 = element.getElementsByTagName("des_obj_version")) != null && object2.getLength() > 0 && (string = (object = (Element)object2.item(0)).getAttribute("version")) != null) {
            try {
                float f = Float.parseFloat(string);
                ((DesignObject)modelIDObject).setLoadedVersion(f);
            }
            catch (NumberFormatException numberFormatException) {
                ((DesignObject)modelIDObject).setLoadedVersion(0.0f);
            }
        }
        this.readObjectInfo(element, modelIDObject, bl);
    }

    protected void readChange(Element element, ModelIDObject modelIDObject, String string) {
        ObjectChange objectChange = null;
        if ("created".equals(string)) {
            objectChange = modelIDObject.getCreation();
        } else if ("changed".equals(string)) {
            objectChange = modelIDObject.getChange();
        } else {
            return;
        }
        Element element2 = ReadStAlDomains.getFirstChildByTagName(element, "user");
        objectChange.setUser(MDUserFactory.getInstance().getUser(element2.getFirstChild().getNodeValue()));
        Element element3 = ReadStAlDomains.getFirstChildByTagName(element, "timestamp");
        objectChange.setTimeString(element3.getFirstChild().getNodeValue());
    }

    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof Domain) {
            String string;
            Domain domain = (Domain)modelIDObject;
            String string2 = element.getAttribute("synonym");
            if (string2 != null) {
                domain.setSynonym(StringUtilities.decodeAttributeValue(string2));
            }
            if ((string = element.getAttribute("dimension")) != null) {
                domain.setDimension(StringUtilities.decodeAttributeValue(string));
            }
        }
    }

    protected void readDataTypeParameters(Element element, Domain domain) {
        Element element2 = ReadStAlDomains.getFirstChildByTagName(element, "parameters");
        if (element2 != null) {
            NodeList nodeList = element.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                domain.setDataTypeParameter(element3.getAttribute("name"), StringUtilities.decodeAttributeValue(element3.getAttribute("value")));
            }
        }
    }

    protected DesignObject instantiateDesignObject(String string) {
        return this.getDomainSet().createDomain(string);
    }

    protected void readConstraint(Element element, Domain domain) {
        NodeList nodeList = element.getElementsByTagName("constraint");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string = element2.getAttribute("type");
            Constraint constraint = domain.getDesign().getConstraintSet().createConstraint(string);
            this.readConstraintInfo(element2, constraint);
            this.readPropertiesListLocateRoot(element2, constraint);
            if (string.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(element2, constraint);
                domain.setCheck((CheckConstraint)constraint);
            } else if (string.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                domain.setValueList((ConstraintEnumeration)constraint);
            }
            if (nodeList.getLength() > 1) {
                element2 = (Element)nodeList.item(1);
                string = element2.getAttribute("type");
                constraint = domain.getDesign().getConstraintSet().createConstraint(string);
                this.readConstraintInfo(element2, constraint);
                this.readPropertiesListLocateRoot(element2, constraint);
                if (string.equalsIgnoreCase("check constraint")) {
                    domain.setCheck((CheckConstraint)constraint);
                } else if (string.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                    domain.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    protected void readPropertiesListLocateRoot(Element element, PropertyMap propertyMap) {
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() > 0) {
            this.readPropertiesList((Element)nodeList.item(0), propertyMap);
        }
    }

    protected void readPropertiesList(Element element, PropertyMap propertyMap) {
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            this.doReadPropertyFromParameterElement(element2, propertyMap);
        }
    }

    private void doReadPropertyFromParameterElement(Element element, PropertyMap propertyMap) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("value");
        propertyMap.setProperty(string, ReadStAlDomains.decodeAttributeValue(string2));
    }

    public static String decodeAttributeValue(String string) {
        return StringUtilities.decodeAttributeValue(string);
    }

    private void readConstraintEnumerationList(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() > 0) {
            this.readConstraintEnumeration((Element)nodeList.item(0), constraintEnumeration);
        }
    }

    private void readConstraintEnumeration(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("value");
            String string2 = element2.getAttribute("desc");
            constraintEnumeration.add(string, string2);
        }
    }

    protected void readConstraintInfo(Element element, Constraint constraint) {
        try {
            Element element2 = ReadStAlDomains.getFirstChildByTagName(element, "name");
            if (element2 != null && element2.getFirstChild() != null) {
                String string = element2.getFirstChild().getNodeValue();
                constraint.setName(string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    protected void readAVT(Element element, Domain domain) {
        NodeList nodeList = element.getElementsByTagName("avt");
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string;
                Element element2 = (Element)nodeList.item(i);
                AVT aVT = null;
                Element element3 = ReadStAlDomains.getFirstChildByTagName(element2, "beginvalue");
                if (element3 != null && element3.getFirstChild() != null && (string = element3.getFirstChild().getNodeValue()) != null) {
                    aVT = new AVT(StringUtilities.decodeAttributeValue(string), "", "");
                }
                if ((element3 = ReadStAlDomains.getFirstChildByTagName(element2, "endvalue")) != null && element3.getFirstChild() != null && (string = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setEndValue(StringUtilities.decodeAttributeValue(string));
                    } else {
                        aVT = new AVT("", StringUtilities.decodeAttributeValue(string), "");
                    }
                }
                if ((element3 = ReadStAlDomains.getFirstChildByTagName(element2, "description")) != null && element3.getFirstChild() != null && (string = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setDescription(StringUtilities.decodeAttributeValue(string));
                    } else {
                        aVT = new AVT("", "", StringUtilities.decodeAttributeValue(string));
                    }
                }
                if (aVT == null) continue;
                domain.addAVT(aVT);
            }
        }
    }

    public static Element getFirstChildByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    public static void main(String[] stringArray) {
    }

    public DomainSet getDomainSet() {
        if (this.domainSet == null) {
            this.domainSet = new DomainSet(this.targetDesgn.getLogicalDesign());
            this.domainSet.setDesign(this.targetDesgn);
            this.domainSet.setName("Domains");
            this.domainSet.createUnknownDomain();
        }
        return this.domainSet;
    }

    public Design getDesign() {
        return this.design;
    }

    public Design getTargetDesgn() {
        return this.targetDesgn;
    }
}

