/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WXMLTransformationTask
extends AbstractXMLWriter {
    private TransformationTask design = null;

    public WXMLTransformationTask(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof TransformationTask;
        if (bl) {
            this.design = (TransformationTask)object;
        }
        return bl;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (TransformationTask)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            if (this.design.getMainView() != null) {
                element.setAttribute("main_view_id", this.design.getMainView().getDPVId());
            } else {
                element.setAttribute("main_view_id", "null");
            }
            Element element2 = document.createElement("input_parameters");
            Element element3 = document.createElement("output_parameters");
            element.appendChild(element2);
            element.appendChild(element3);
            this.appendParameterElement(element2, this.design.getInputParamsObject());
            this.appendParameterElement(element3, this.design.getOutputParamsObject());
            Element element4 = document.createElement("ref");
            element.appendChild(element4);
            this.appendSources(document, element);
            this.appendTargets(document, element);
            Element element5 = document.createElement("synonyms_for_globals");
            element.appendChild(element5);
            Element element6 = document.createElement("view_flows");
            element.appendChild(element6);
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                this.handleDesignObject(element4, designObject);
            }
            this.handleSynonymsForGlobals(this.design, element5);
            this.handleFlows(this.design, element6);
            this.appendDisplayProperties(element, this.design.getMainView());
            this.appendDiagramViews(document, element, this.design);
            this.design.setDirty(false);
            return document;
        }
        return null;
    }

    private void appendSources(Document document, Element element) {
        Element element2 = document.createElement("source_stores");
        Iterator iterator = this.design.getSources().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element2.setAttribute("id", stringBuffer.toString());
        element.appendChild(element2);
    }

    private void appendTargets(Document document, Element element) {
        Element element2 = document.createElement("target_stores");
        Iterator iterator = this.design.getTargets().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element2.setAttribute("id", stringBuffer.toString());
        element.appendChild(element2);
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(element2, designObject);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        DesignPart designPart = (DesignPart)object;
        return designPart.getPathIDString();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("pm/tp").append('/').append(StringUtilities.encodeAttributeValue(this.design.getTransformationPackage().getObjectID())).append('/');
            return stringBuffer.toString();
        }
        return "pm/tp/tasks/";
    }

    public void handleFlows(TransformationTask transformationTask, Element element) {
        if (transformationTask.getAppView() != null) {
            DesignPartView designPartView = transformationTask.getMainView();
            Iterator iterator = transformationTask.getFlowSet().iterator();
            while (iterator.hasNext()) {
                Flow flow = (Flow)iterator.next();
                if (flow.getSourceTV(designPartView) == null && flow.getTargetTV(designPartView) == null) continue;
                this.appendFlowObjectElement(transformationTask, element, flow);
            }
        }
    }

    public void handleSynonymsForGlobals(TransformationTask transformationTask, Element element) {
        if (transformationTask.getAppView() != null) {
            ArrayList arrayList = new ArrayList();
            transformationTask.getStores().addAllElementsTo(arrayList);
            DesignPartView designPartView = transformationTask.getMainView();
            for (DesignObjectPlaceHolder designObjectPlaceHolder : arrayList) {
                AbstractProcessObject abstractProcessObject = (AbstractProcessObject)designObjectPlaceHolder.getDesignObject();
                this.appendSynonymForGlobalElement(element, abstractProcessObject, designPartView);
            }
        }
    }

    private void appendSynonymForGlobalElement(Element element, AbstractProcessObject abstractProcessObject, DesignPartView designPartView) {
        Document document = element.getOwnerDocument();
        TopView topView = (TopView)abstractProcessObject.getViewsForDPV(designPartView).get(0);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", abstractProcessObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(abstractProcessObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(abstractProcessObject.getObjectID()));
        this.appendGraphicalInfo(element2, abstractProcessObject, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject, TopView topView) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    private void appendFlowObjectElement(TransformationTask transformationTask, Element element, Flow flow) {
        Object object;
        Object object2;
        EdgeView edgeView;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = transformationTask.getMainView();
        TVFlow tVFlow = (TVFlow)flow.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(flow.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(flow.getObjectID()));
        element2.setAttribute("viewid_source", flow.getSourceTV(designPartView) != null ? flow.getSourceTV(designPartView).getViewID() : "null");
        element2.setAttribute("viewid_target", flow.getTargetTV(designPartView) != null ? flow.getTargetTV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVFlow != null) {
            edgeView = (EdgeView)((DefaultEdge)tVFlow.getCellView().getCell()).getCellView();
            object2 = edgeView.getPoints();
            for (int i = 0; i < object2.size(); ++i) {
                object = object2.get(i);
                Point2D point2D = object instanceof PortView ? ((PortView)object).getPoint() : (Point2D)object;
                if (point2D == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (tVFlow != null) {
            edgeView = (EdgeView)tVFlow.getCellView();
            if (edgeView != null) {
                object2 = document.createElement("labels");
                Element element5 = document.createElement("main_label");
                element5.setAttribute("x_coordinate", Double.toString(tVFlow.getLabelBounds().getX()));
                element5.setAttribute("y_coordinate", Double.toString(tVFlow.getLabelBounds().getY()));
                element5.setAttribute("width", Double.toString(tVFlow.getLabelBounds().getWidth()));
                element5.setAttribute("height", Double.toString(tVFlow.getLabelBounds().getHeight()));
                object2.appendChild(element5);
                object = tVFlow.getLabel(1);
                if (object != null) {
                    this.appendDesignObjectColor(element5, (DesignObject)object);
                    this.appendDesignObjectFonts(element5, (DesignObject)object);
                }
                element2.appendChild((Node)object2);
            }
            object2 = document.createElement("graphical");
            Element element6 = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild(element6);
            element6.setAttribute("name", "use_default_color");
            element6.setAttribute("value", Boolean.toString(tVFlow.useDefaultColor()));
            if (!tVFlow.useDefaultColor()) {
                element6 = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild(element6);
                element6.setAttribute("name", "color");
                element6.setAttribute("value", tVFlow.getBackgroundColor() != null ? Integer.toString(tVFlow.getBackgroundColor().getRGB()) : "null");
                element6 = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild(element6);
                element6.setAttribute("name", "width");
                element6.setAttribute("value", Integer.toString(tVFlow.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }

    private void appendParameterElement(Element element, DesignObject designObject) {
        Document document = element.getOwnerDocument();
        InOutParams inOutParams = (InOutParams)designObject;
        element.setAttribute("parameters_multiplicity", inOutParams.getParametersMultiplicity());
        Element element2 = document.createElement("comment");
        Text text = document.createTextNode(StringUtilities.encodeAttributeValue(designObject.getComment()));
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("notes");
        text = document.createTextNode(designObject.getNotes());
        element2.appendChild(text);
        element.appendChild(element2);
        this.appendDesignObjectColor(element, designObject);
        this.appendDesignObjectFonts(element, designObject);
        for (ParameterObject parameterObject : inOutParams.getParams()) {
            this.appendParamInfo(element, parameterObject);
        }
        this.appendGraphicalInfo(element, designObject);
    }

    public void appendParamInfo(Element element, ParameterObject parameterObject) {
        Element element2 = element.getOwnerDocument().createElement("inout_parameter");
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(parameterObject.getObjectID()));
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(parameterObject.getName()));
        element2.setAttribute("dttype", StringUtilities.encodeAttributeValue(parameterObject.getLogicalDatatype().getName()));
        element.appendChild(element2);
    }
}

