/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLTransformationFlow
extends AbstractWXMLDesignObject
implements DFConstants {
    private Flow flow = null;

    public WXMLTransformationFlow(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl;
        boolean bl2 = bl = TransformationFlow.class == object.getClass();
        if (bl) {
            this.flow = (Flow)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.flow != null) {
            String string = this.flow.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm/tp").append('/').append(StringUtilities.encodeAttributeValue(((TransformationTask)this.flow.getDesignPart()).getTransformationPackage().getObjectID())).append('/').append(this.flow.getDesignPart().getPathIDString()).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("flowPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Flow) {
            Flow flow = (Flow)designObject;
            element.setAttribute("synonym", flow.getSynonym());
            this.appendConnectionInfo(element, flow.getSourceConnection(), "source");
            this.appendConnectionInfo(element, flow.getTargetConnection(), "target");
            this.appendParentInfo(element, flow.getParentObject(), "parent");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("event", flow.getEvent() != null ? StringUtilities.encodeAttributeValue(flow.getEvent().getObjectID()) : "null");
            treeMap.put("loggingflow", String.valueOf(flow.isLogging()));
            treeMap.put("systemobjective", flow.getSystemObjective());
            treeMap.put("opCreate", String.valueOf(flow.isOpCreate()));
            treeMap.put("opRead", String.valueOf(flow.isOpRead()));
            treeMap.put("opUpdate", String.valueOf(flow.isOpUpdate()));
            treeMap.put("opDelete", String.valueOf(flow.isOpDelete()));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, flow.getInfoStructures().toArray(), "infostructures");
        }
    }

    private void appendConnectionInfo(Element element, Flow.Connection connection, String string) {
        Element element2 = element.getOwnerDocument().createElement("connection");
        element.appendChild(element2);
        element2.setAttribute("endpoint", string);
        element2.setAttribute("dfobject", connection.getProcessObject() != null ? StringUtilities.encodeAttributeValue(connection.getProcessObject().getObjectID()) : "null");
    }

    private void appendParentInfo(Element element, AbstractProcessObject abstractProcessObject, String string) {
        Element element2 = element.getOwnerDocument().createElement("connection");
        element.appendChild(element2);
        element2.setAttribute("endpoint", string);
        element2.setAttribute("dfobject", abstractProcessObject != null ? StringUtilities.encodeAttributeValue(abstractProcessObject.getObjectID()) : "null");
    }
}

