/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLTransformation
extends AbstractWXMLDesignObject
implements DFConstants {
    private Transformation process = null;

    public WXMLTransformation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl;
        boolean bl2 = bl = Transformation.class == object.getClass();
        if (bl) {
            this.process = (Transformation)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.process != null) {
            String string = this.process.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm/tp").append('/').append(StringUtilities.encodeAttributeValue(((TransformationTask)this.process.getDesignPart()).getTransformationPackage().getObjectID())).append('/').append(this.process.getDesignPart().getPathIDString()).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("processPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (Transformation.class == designObject.getClass()) {
            Transformation transformation = (Transformation)designObject;
            if (transformation.getSynonym() != null && !transformation.getSynonym().equalsIgnoreCase("")) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(transformation.getSynonym()));
            }
            Element element2 = this.createElement(element, "primary");
            element2.setAttribute("is_primary", transformation.isPrimary() ? VALUE_TRUE : VALUE_FALSE);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("filter_condition", transformation.getFilterCondition());
            treeMap.put("join_condition", transformation.getJoinCondition());
            this.appendProperties(element, "attributes", treeMap);
            transformation.updateTargetElements();
            Element element3 = element.getOwnerDocument().createElement("contained");
            element.appendChild(element3);
            for (TargetElement targetElement : transformation.getTargetElements()) {
                this.appendTargetInfo(element3, targetElement);
            }
        }
    }

    private void appendTargetInfo(Element element, TargetElement targetElement) {
        Element element2 = element.getOwnerDocument().createElement("targetelement");
        Element element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "attributeid", StringUtilities.encodeAttributeValue(targetElement.getTarget().getObjectID()));
        Iterator iterator = targetElement.getSources().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "sources", stringBuffer.toString());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "type", targetElement.getTransformationType());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "description", targetElement.getDescription());
        element.appendChild(element2);
    }
}

