/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLTransfomationPackage
extends AbstractWXMLDesignObject
implements DFConstants {
    private TransformationPackage trPackage = null;

    public WXMLTransfomationPackage(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof TransformationPackage;
        if (bl) {
            this.trPackage = (TransformationPackage)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trPackage != null) {
            String string = this.trPackage.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm/tp").append('/');
        }
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
    }

    @Override
    protected void appendContainedElements(Document document, Element element, DesignObject designObject) {
        TransformationPackage transformationPackage = (TransformationPackage)designObject;
        Element element2 = document.createElement("ref");
        Iterator iterator = transformationPackage.getTransformationTaskSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            TransformationTask transformationTask = (TransformationTask)e;
            if (!this.getPersistenceManager().isXML_FromDataBase()) {
                boolean bl = this.getPersistenceManager().isCheckDirty() ? transformationTask.isDirty() || transformationTask.hasDirtyStorableObjects() : true;
                if (bl) {
                    transformationTask.save();
                    transformationTask.setDirty(false);
                }
            }
            this.appendReferencedObjectElement(element2, transformationTask);
        }
        element.appendChild(element2);
    }

    private void appendReferencedObjectElement(Element element, TransformationTask transformationTask) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("transformation_task");
        element2.setAttribute("role", transformationTask.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(transformationTask.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(transformationTask.getObjectID()));
        element2.setAttribute("pathid", transformationTask.getPathIDString());
        element2.setAttribute("is_visible", String.valueOf(transformationTask.isMainViewVisible()));
        element2.setAttribute("input_parameters_id", StringUtilities.encodeAttributeValue(transformationTask.getInputParamsObject().getObjectID()));
        element2.setAttribute("output_parameters_id", StringUtilities.encodeAttributeValue(transformationTask.getOutputParamsObject().getObjectID()));
        Element element3 = document.createElement("name");
        element3.appendChild(document.createTextNode(transformationTask.getName()));
        element2.appendChild(element3);
        Element element4 = document.createElement("comment");
        if (transformationTask.getComment() != null && !"".equalsIgnoreCase(transformationTask.getComment())) {
            element4.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(transformationTask.getComment())));
        }
        element2.appendChild(element4);
        element.appendChild(element2);
    }
}

