/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLProcessModel
extends AbstractXMLWriter {
    private ProcessModel processModel = null;

    public WXMLProcessModel(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof ProcessModel;
    }

    @Override
    public Document writeDocument(Object object) {
        this.processModel = (ProcessModel)object;
        Document document = this.createDocument("design");
        Element element = document.getDocumentElement();
        element.setAttribute("id", StringUtilities.encodeAttributeValue(this.processModel.getObjectID()));
        Element element2 = document.createElement("ref");
        element.appendChild(element2);
        Collection collection = this.processModel.getStorableDesignObjects();
        Iterator iterator = collection.iterator();
        DesignObject designObject = null;
        while (iterator.hasNext()) {
            designObject = (DesignObject)iterator.next();
            this.handleDesignObject(element2, designObject);
        }
        if (this.processModel.getMainView() != null) {
            this.appendDisplayProperties(element, this.processModel.getMainView());
        }
        this.processModel.setDirty(false);
        return document;
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.getPersistenceManager().write(designObject);
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (designObject.hasGUIView()) {
            this.appendGraphicalInfo(element2, designObject);
        }
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        ProcessModel processModel = (ProcessModel)object;
        return StringUtilities.encodeAttributeValue(processModel.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.processModel != null && this.processModel.getAppView() != null) {
            String string = this.processModel.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("pm");
            return stringBuffer.toString();
        }
        return "pm";
    }
}

