/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLExternalData
extends AbstractWXMLDesignObject
implements DFConstants {
    private ExternalData extData;

    public WXMLExternalData(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof ExternalData;
        if (bl) {
            this.extData = (ExternalData)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.extData != null) {
            String string = this.extData.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("extDataPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof ExternalData) {
            ExternalData externalData = (ExternalData)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("structured", new Boolean(externalData.isStructured()).toString());
            String string = "";
            if (externalData.getRecordStructure() != null) {
                string = externalData.getRecordStructure().getObjectID();
            }
            treeMap.put("recordstructure", string);
            string = "";
            if (externalData.getType() != null) {
                string = externalData.getType().getObjectID();
            }
            treeMap.put("type", StringUtilities.encodeAttributeValue(string));
            treeMap.put("startingpos", Integer.toString(externalData.getStartingPos()));
            treeMap.put("description", externalData.getDescription());
            if (externalData.getMappedDesignObject() != null) {
                treeMap.put("mappedobject", StringUtilities.encodeAttributeValue(externalData.getMappedDesignObject().getObjectID()));
            } else {
                treeMap.put("mappedobject", "");
            }
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

