/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLDataFlowDesign
extends AbstractXMLWriter {
    private DataFlowDesign design = null;

    public WXMLDataFlowDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DataFlowDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (DataFlowDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            element.setAttribute("top_level_dfd_design", String.valueOf(this.design.isTopLevel()));
            Element element2 = document.createElement("ref");
            element.appendChild(element2);
            Element element3 = document.createElement("synonyms_for_globals");
            element.appendChild(element3);
            Element element4 = document.createElement("view_flows");
            element.appendChild(element4);
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                this.handleDesignObject(element2, designObject);
            }
            this.handleSynonymsForGlobals(this.design, element3);
            this.handleFlows(this.design, element4);
            this.appendDisplayProperties(element, this.design.getMainView());
            this.appendDocumentsInfo(document, element, this.design);
            this.appendPartiesInfo(document, element, this.design);
            this.appendDiagramViews(document, element, this.design);
            this.design.setDirty(false);
            this.design.getMainView().setDirty(false);
            this.design.getMainDPVPlaceHolder().setDirty(false);
            return document;
        }
        return null;
    }

    private void appendDocumentsInfo(Document document, Element element, DataFlowDesign dataFlowDesign) {
        this.appendObjects(element, dataFlowDesign.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, DataFlowDesign dataFlowDesign) {
        this.appendObjects(element, dataFlowDesign.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        }
        this.appendProperties(element, string, treeMap);
    }

    @Override
    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (designObject instanceof Process) {
            element2.setAttribute("process_number", String.valueOf(this.design.getProcessNumber((Process)designObject)));
        }
        this.appendGraphicalInfo(element2, designObject);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        DataFlowDesign dataFlowDesign = (DataFlowDesign)object;
        return StringUtilities.encodeAttributeValue(dataFlowDesign.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("pm/dflows");
            return stringBuffer.toString();
        }
        return "pm/dflows";
    }

    public void handleFlows(DataFlowDesign dataFlowDesign, Element element) {
        if (dataFlowDesign.getAppView() != null) {
            DesignPartView designPartView = dataFlowDesign.getMainView();
            Iterator iterator = dataFlowDesign.getFlowSet().iterator();
            while (iterator.hasNext()) {
                Flow flow = (Flow)iterator.next();
                if (flow.getSourceTV(designPartView) == null && flow.getTargetTV(designPartView) == null) continue;
                this.appendFlowObjectElement(dataFlowDesign, element, flow);
            }
        }
    }

    public void handleSynonymsForGlobals(DataFlowDesign dataFlowDesign, Element element) {
        if (dataFlowDesign.getAppView() != null) {
            ArrayList arrayList = new ArrayList();
            dataFlowDesign.getAgents().addAllElementsTo(arrayList);
            dataFlowDesign.getStores().addAllElementsTo(arrayList);
            dataFlowDesign.getExtProcesses().addAllElementsTo(arrayList);
            DesignPartView designPartView = dataFlowDesign.getMainView();
            for (DesignObjectPlaceHolder designObjectPlaceHolder : arrayList) {
                AbstractProcessObject abstractProcessObject = (AbstractProcessObject)designObjectPlaceHolder.getDesignObject();
                this.appendSynonymForGlobalElement(element, abstractProcessObject, designPartView);
            }
        }
    }

    private void appendSynonymForGlobalElement(Element element, AbstractProcessObject abstractProcessObject, DesignPartView designPartView) {
        Document document = element.getOwnerDocument();
        TopView topView = (TopView)abstractProcessObject.getViewsForDPV(designPartView).get(0);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", abstractProcessObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(abstractProcessObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(abstractProcessObject.getObjectID()));
        this.appendGraphicalInfo(element2, abstractProcessObject, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject, TopView topView) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            String string = (String)map.get("viewtype");
            element2.setAttribute("viewtype", string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string2 = (String)iterator.next();
                element3.setAttribute("name", string2);
                element3.setAttribute("value", (String)map.get(string2));
            }
            element.appendChild(element2);
        }
    }

    private void appendFlowObjectElement(DataFlowDesign dataFlowDesign, Element element, Flow flow) {
        Object object;
        Object object2;
        Object object3;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = dataFlowDesign.getMainView();
        TVFlow tVFlow = (TVFlow)flow.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", flow.getObjectTypeName());
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(flow.getObjectID()));
        element2.setAttribute("viewid_source", flow.getSourceTV(designPartView) != null ? flow.getSourceTV(designPartView).getViewID() : "null");
        element2.setAttribute("viewid_target", flow.getTargetTV(designPartView) != null ? flow.getTargetTV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVFlow != null) {
            if (tVFlow.getCellView() != null) {
                object3 = (EdgeView)((DefaultEdge)tVFlow.getCellView().getCell()).getCellView();
                object2 = ((EdgeView)object3).getPoints();
                for (int i = 0; i < object2.size(); ++i) {
                    object = object2.get(i);
                    Object object4 = object instanceof PortView ? ((PortView)object).getPoint() : object;
                    if (object4 == null) continue;
                    Element element4 = document.createElement("point");
                    element4.setAttribute("x_coordinate", Double.toString(((Point2D)object4).getX()));
                    element4.setAttribute("y_coordinate", Double.toString(((Point2D)object4).getY()));
                    element3.appendChild(element4);
                }
            } else {
                object3 = tVFlow.getEdgePoints();
                for (int i = 0; i < object3.size(); ++i) {
                    Object e = object3.get(i);
                    object = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                    if (object == null) continue;
                    Element element5 = document.createElement("point");
                    element5.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                    element5.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                    element3.appendChild(element5);
                }
            }
        }
        element2.appendChild(element3);
        if (tVFlow != null) {
            object3 = (EdgeView)tVFlow.getCellView();
            if (object3 != null) {
                object2 = document.createElement("labels");
                Element element6 = document.createElement("main_label");
                element6.setAttribute("x_coordinate", Double.toString(tVFlow.getLabelBounds().getX()));
                element6.setAttribute("y_coordinate", Double.toString(tVFlow.getLabelBounds().getY()));
                element6.setAttribute("width", Double.toString(tVFlow.getLabelBounds().getWidth()));
                element6.setAttribute("height", Double.toString(tVFlow.getLabelBounds().getHeight()));
                object2.appendChild(element6);
                object = tVFlow.getLabel(1);
                if (object != null) {
                    this.appendDesignObjectColor(element6, (DesignObject)object);
                    this.appendDesignObjectFonts(element6, (DesignObject)object);
                }
                element2.appendChild((Node)object2);
            }
            object2 = document.createElement("graphical");
            Element element7 = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild(element7);
            element7.setAttribute("name", "use_default_color");
            element7.setAttribute("value", Boolean.toString(tVFlow.useDefaultColor()));
            if (!tVFlow.useDefaultColor()) {
                element7 = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild(element7);
                element7.setAttribute("name", "color");
                element7.setAttribute("value", tVFlow.getBackgroundColor() != null ? Integer.toString(tVFlow.getBackgroundColor().getRGB()) : "null");
                element7 = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild(element7);
                element7.setAttribute("name", "width");
                element7.setAttribute("value", Integer.toString(tVFlow.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }
}

