/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLAgent
extends AbstractWXMLDesignObject
implements DFConstants {
    private ExternalAgent agent = null;

    public WXMLAgent(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof ExternalAgent;
        if (bl) {
            this.agent = (ExternalAgent)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.agent != null) {
            String string = this.agent.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("pm/dflows").append('/').append(StringUtilities.encodeAttributeValue(this.agent.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("agentPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof ExternalAgent) {
            ExternalAgent externalAgent = (ExternalAgent)designObject;
            if (externalAgent.getSynonym() != null && !"".equalsIgnoreCase(externalAgent.getSynonym())) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(externalAgent.getSynonym()));
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("type", String.valueOf(externalAgent.getType()));
            treeMap.put("agentowner", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getOwner())));
            treeMap.put("agentsource", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getSource())));
            treeMap.put("filename", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getFileName())));
            treeMap.put("location", StringUtilities.encodeAttributeValue(StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getLocation()))));
            treeMap.put("filetype", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getFileType())));
            treeMap.put("fieldseparator", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getFieldSeparator())));
            treeMap.put("transfertype", StringUtilities.encodeAttributeValue(String.valueOf(externalAgent.getTransferType())));
            treeMap.put("selfDescribing", new Boolean(externalAgent.isSelfDescribing()).toString());
            treeMap.put("skipRecords", new Integer(externalAgent.getSkipRecords()).toString());
            treeMap.put("textDelimiter", StringUtilities.encodeAttributeValue(externalAgent.getTextDelimiter()));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, externalAgent.getExternalDatas().toArray(), "agentextdatas");
        }
    }
}

