/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationTask
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER = new Logger(RXMLTransformationTask.class);

    public RXMLTransformationTask(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string));
        }
        TransformationTask transformationTask = (TransformationTask)designPart;
        String string2 = element.getAttribute("main_view_id");
        if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
            transformationTask.getMainView().setDPVId(string2);
        }
        this.readInputParams(element, "input_parameters", transformationTask.getInputParamsObject());
        this.readInputParams(element, "output_parameters", transformationTask.getOutputParamsObject());
        NodeList nodeList = RXMLTransformationTask.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("role");
            String string4 = element2.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase(string3) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string4, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string4);
            if (designObject != null) {
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                this.readGraphicalInfo(element2, designObject);
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLTransformationTask: Read object returns null (objectID: " + string4);
        }
        this.readSources(element, transformationTask, designPart);
        this.readTargets(element, transformationTask, designPart);
        this.readSynonymsForGlobals(element, (TransformationTask)designPart);
        this.readFlows(element, (TransformationTask)designPart);
        this.readDisplayProperties(element, designPart.getMainView());
        designPart.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(element, designPart);
        designPart.setLoaded(true);
        return designPart;
    }

    private void readSources(Element element, TransformationTask transformationTask, DesignPart designPart) {
        NodeList nodeList = element.getElementsByTagName("source_stores");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (i != 0) continue;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("id");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                DesignObject designObject = designPart.getDesign().getDesignObject(string2);
                if (designObject == null) continue;
                transformationTask.addSource((InfoStore)designObject);
            }
        }
    }

    private void readTargets(Element element, TransformationTask transformationTask, DesignPart designPart) {
        NodeList nodeList = element.getElementsByTagName("target_stores");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (i != 0) continue;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("id");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                DesignObject designObject = designPart.getDesign().getDesignObject(string2);
                if (designObject == null) continue;
                transformationTask.addTarget((InfoStore)designObject);
            }
        }
    }

    private void readInputParams(Element element, String string, InOutParams inOutParams) {
        Element element2 = RXMLTransformationTask.getFirstChildByTagName(element, string);
        String string2 = element2.getAttribute("parameters_multiplicity");
        inOutParams.setParametersMultiplicity(string2);
        String string3 = "";
        if (RXMLTransformationTask.getFirstChildByTagName(element2, "comment").getFirstChild() != null) {
            string3 = RXMLTransformationTask.getFirstChildByTagName(element2, "comment").getFirstChild().getNodeValue();
        }
        String string4 = "";
        if (RXMLTransformationTask.getFirstChildByTagName(element2, "comment").getFirstChild() != null) {
            string4 = RXMLTransformationTask.getFirstChildByTagName(element2, "comment").getFirstChild().getNodeValue();
        }
        inOutParams.setNotes(string4);
        inOutParams.setComment(StringUtilities.decodeAttributeValue(string3));
        this.readColorInfo(element2, inOutParams);
        this.readFontsInfo(element2, inOutParams);
        NodeList nodeList = element2.getElementsByTagName("inout_parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string5 = element3.getAttribute("oid");
            String string6 = element3.getAttribute("name");
            String string7 = element3.getAttribute("dttype");
            inOutParams.addParam(string5, string6, string7);
        }
        this.readGraphicalInfo(element2, inOutParams);
    }

    private void readFlows(Element element, TransformationTask transformationTask) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLTransformationTask.ReadFlows"));
        DesignPartView designPartView = transformationTask.getMainView();
        if (transformationTask.getAppView() != null && (element2 = RXMLTransformationTask.getFirstChildByTagName(element, "view_flows")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                String string;
                Object object3;
                Object object4;
                Element element3;
                Object object5;
                Object object6;
                Element element4 = (Element)nodeList.item(i);
                String string2 = element4.getAttribute("oid");
                Flow flow = (Flow)transformationTask.getFlowSet().getObjectByID(string2);
                String string3 = element4.getAttribute("viewid_source");
                String string4 = element4.getAttribute("viewid_target");
                if (!string3.equals("null") && ((ArrayList)(object6 = flow.getSourceProcessObject().getViewsForDPV(designPartView))).size() == 1) {
                    object5 = (TopView)((ArrayList)object6).get(0);
                    flow.setSourceTV((AbstractDataFlowTV)object5);
                }
                if (!string4.equals("null") && ((ArrayList)(object6 = flow.getTargetProcessObject().getViewsForDPV(designPartView))).size() == 1) {
                    object5 = (TopView)((ArrayList)object6).get(0);
                    flow.setTargetTV((AbstractDataFlowTV)object5);
                }
                object6 = RXMLTransformationTask.getFirstChildByTagName(element4, "points");
                object5 = object6.getElementsByTagName("point");
                int n2 = object5.getLength();
                TVFlow tVFlow = (TVFlow)flow.getTopView();
                for (int j = 0; j < n2; ++j) {
                    element3 = (Element)object5.item(j);
                    object4 = element3.getAttribute("x_coordinate");
                    object3 = element3.getAttribute("y_coordinate");
                    tVFlow.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object4), Double.parseDouble((String)object3)));
                }
                Element element5 = RXMLTransformationTask.getFirstChildByTagName(element4, "labels");
                if (element5 != null && (element3 = RXMLTransformationTask.getFirstChildByTagName(element5, "main_label")) != null) {
                    object4 = element3.getAttribute("x_coordinate");
                    object3 = element3.getAttribute("y_coordinate");
                    String string5 = element3.getAttribute("width");
                    string = element3.getAttribute("height");
                    if (string5 == null || "".equalsIgnoreCase(string5)) {
                        string5 = "-1";
                    }
                    if (string == null || "".equalsIgnoreCase(string)) {
                        string = "-1";
                    }
                    tVFlow.setLabelBounds(new Rectangle((int)Double.parseDouble((String)object4), (int)Double.parseDouble((String)object3), (int)Double.parseDouble(string5), (int)Double.parseDouble(string)));
                    object2 = tVFlow.getTempCenterLabel();
                    if (object2 != null) {
                        this.readColorInfo(element3, (DesignObject)object2);
                        this.readFontsInfo(element3, (DesignObject)object2);
                    }
                }
                if ((element3 = RXMLTransformationTask.getFirstChildByTagName(element4, "graphical")) == null) continue;
                object4 = element3.getElementsByTagName("parameter");
                object3 = new HashMap();
                int n3 = object4.getLength();
                for (int j = 0; j < n3; ++j) {
                    object2 = (Element)object4.item(j);
                    object3.put(object2.getAttribute("name"), object2.getAttribute("value"));
                }
                string = (String)object3.get("use_default_color");
                boolean bl = true;
                if (string != null) {
                    bl = Boolean.valueOf(string);
                }
                tVFlow.setUseDefaultColor(bl);
                if (bl) continue;
                String string6 = (String)object3.get("color");
                if (string6 != null && !"null".equalsIgnoreCase(string6)) {
                    object = new Color(Integer.parseInt(string6));
                    tVFlow.setBackgroundColor((Color)object);
                }
                if ((object = (String)object3.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                int n4 = Integer.parseInt((String)object);
                tVFlow.setLineWidth(n4);
            }
        }
    }

    private void readSynonymsForGlobals(Element element, TransformationTask transformationTask) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLTransformationTask.ReadSynonymsForGlobalPMObjects"));
        DPVTransformation dPVTransformation = (DPVTransformation)transformationTask.getMainView();
        if (transformationTask.getAppView() != null && (element2 = RXMLTransformationTask.getFirstChildByTagName(element, "synonyms_for_globals")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("oid");
                String string2 = element3.getAttribute("type");
                AbstractProcessObject abstractProcessObject = null;
                if ("InfoStore".equalsIgnoreCase(string2)) {
                    abstractProcessObject = (AbstractProcessObject)transformationTask.getInfoStoreSet().getObjectByID(string);
                } else if ("Process".equalsIgnoreCase(string2)) {
                    abstractProcessObject = (AbstractProcessObject)transformationTask.getDesign().getDesignObject(string);
                }
                if (abstractProcessObject == null || dPVTransformation == null) continue;
                TopView topView = abstractProcessObject.getFirstViewForDPV(dPVTransformation);
                if (topView == null) {
                    topView = dPVTransformation.createViewSynonim(abstractProcessObject);
                }
                this.readGraphicalInfo(element3, abstractProcessObject, topView);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject, TopView topView) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            Design design = this.getPersistenceManager().getAppView().getCurrentDesign();
            StringBuffer stringBuffer = new StringBuffer();
            if (design.getProcessModel().getTransformationPackage() != null) {
                stringBuffer.append(string).append('/');
                if (this.isOldDesign()) {
                    stringBuffer.append("processmodel/tansformationpackages");
                } else {
                    stringBuffer.append("pm/tp");
                }
                stringBuffer.append('/').append(StringUtilities.decodeAttributeValue(design.getProcessModel().getTransformationPackage().getObjectID())).append('/');
            } else {
                stringBuffer.append(string).append('/');
                if (this.isOldDesign()) {
                    stringBuffer.append("processmodel/tansformationpackages");
                } else {
                    stringBuffer.append("pm/tp");
                }
                stringBuffer.append('/');
            }
            return stringBuffer.toString();
        }
        return "pm/tp";
    }
}

