/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.process.TransformationTaskSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationPackage
extends AbstractRXMLDesignObject
implements DFConstants {
    private boolean xmlFromDB = false;

    public RXMLTransformationPackage(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        TransformationPackage transformationPackage = design.getProcessModel().createTransformationPackage(StringUtilities.decodeAttributeValue(string));
        design.getProcessModel().setTransformationPackage(transformationPackage);
        return transformationPackage;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        TransformationPackage transformationPackage = (TransformationPackage)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(transformationPackage.getObjectID())).append(".dmd");
        transformationPackage.setFilePath(stringBuffer.toString());
        this.recreateReferenced(element, design, transformationPackage);
        return transformationPackage;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("processmodel/tansformationpackages");
            } else {
                stringBuffer.append("pm/tp");
            }
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    private void recreateReferenced(Element element, Design design, TransformationPackage transformationPackage) {
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        TransformationTaskSet transformationTaskSet = design.getProcessModel().getTransformationPackage().getTransformationTaskSet();
        Document document = element.getOwnerDocument();
        Element element2 = document.getDocumentElement();
        NodeList nodeList = RXMLTransformationPackage.getFirstChildByTagName(element2, "ref").getElementsByTagName("transformation_task");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Element element3 = (Element)nodeList.item(i);
            String string2 = element3.getAttribute("oid");
            String string3 = element3.getAttribute("type");
            String string4 = RXMLTransformationPackage.getFirstChildByTagName(element3, "name").getFirstChild().getNodeValue();
            String string5 = element3.getAttribute("is_visible");
            String string6 = "";
            if (RXMLTransformationPackage.getFirstChildByTagName(element3, "comment").getFirstChild() != null) {
                string6 = RXMLTransformationPackage.getFirstChildByTagName(element3, "comment").getFirstChild().getNodeValue();
            }
            if (!string3.equalsIgnoreCase("TransformationTask")) continue;
            TransformationTask transformationTask = null;
            transformationTask = !this.xmlFromDB ? design.getProcessModel().getTransformationPackage().createTransformationTask(string2) : (TransformationTask)transformationTaskSet.getObjectByID(string2);
            if (transformationTask == null) continue;
            if (!this.isOldDesign()) {
                string = element3.getAttribute("path_id");
                try {
                    int n2 = Integer.parseInt(string);
                    transformationTask.setPathID(n2);
                    design.getProcessModel().getTransformationPackage().getTransformationTaskSet().updateMaxIndex(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = element3.getAttribute("input_parameters_id");
            String string7 = element3.getAttribute("output_parameters_id");
            boolean bl = false;
            if (string != null && !"".equals(string) && !"null".equals(string)) {
                bl = true;
                transformationTask.getInputParamsObject().setObjectID(string);
            }
            if (string7 != null && !"".equals(string7) && !"null".equals(string7)) {
                bl = true;
                transformationTask.getOutputParamsObject().setObjectID(string7);
            }
            if (!bl) {
                transformationTask.assignOldLocalIDs();
            }
            if (!this.xmlFromDB) {
                transformationTask.load();
            }
            transformationTask.setName(string4);
            transformationTask.setComment(StringUtilities.decodeAttributeValue(string6));
            if (string5 == null) continue;
            transformationTask.setVisible(Boolean.valueOf(string5));
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == TransformationPackage.class;
    }
}

