/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationFlow
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLTransformationFlow(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getTransformationPackage().getLastTaskAdded().createFlow(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Flow flow = (Flow)super.recreateObject(element, design, bl);
        NodeList nodeList = element.getElementsByTagName("connection");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = (Element)nodeList.item(i);
            object2 = object3.getAttribute("dfobject");
            object = (AbstractProcessObject)design.getDesignObject((String)object2);
            if (object == null) {
                objectArray = design.getProcessModel().getTransformationTask();
                if (objectArray != null) {
                    object = objectArray.getInOutParamsObjectById((String)object2);
                }
                if ("source".equals(object3.getAttribute("endpoint"))) {
                    if (object == null) {
                        object = objectArray.getInputParamsObject();
                    }
                } else if ("target".equals(object3.getAttribute("endpoint")) && object == null) {
                    object = objectArray.getOutputParamsObject();
                }
            }
            if ("source".equals(object3.getAttribute("endpoint"))) {
                flow.setSourceProcessObject((AbstractProcessObject)object);
                continue;
            }
            if (!"target".equals(object3.getAttribute("endpoint"))) continue;
            flow.setTargetProcessObject((AbstractProcessObject)object);
        }
        Map map = this.getProperties(element, "attributes");
        object3 = (String)map.get("event");
        if (!"null".equalsIgnoreCase((String)object3) && (object2 = (Event)flow.getDesign().getProcessModel().getEventSet().getObjectByID((String)object3)) != null) {
            flow.setEvent((Event)object2);
        }
        flow.setLogging(Boolean.valueOf((String)map.get("loggingflow")));
        flow.setSystemObjective((String)map.get("systemobjective"));
        flow.setOpCreate(Boolean.valueOf((String)map.get("opCreate")));
        flow.setOpRead(Boolean.valueOf((String)map.get("opRead")));
        flow.setOpUpdate(Boolean.valueOf((String)map.get("opUpdate")));
        flow.setOpDelete(Boolean.valueOf((String)map.get("opDelete")));
        object2 = RXMLTransformationFlow.getFirstChildByTagName(element, "infostructures");
        if (object2 != null) {
            object = this.getProperties(element, "infostructures");
            objectArray = object.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)object.get(objectArray[i]);
                InfoStructure infoStructure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID(string);
                if (infoStructure == null) continue;
                flow.addInfoStructure(infoStructure);
            }
        } else {
            object = (String)map.get("infostructures");
            if (object != null) {
                objectArray = ((String)object).split(",");
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object4 = objectArray[i];
                    InfoStructure infoStructure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID((String)object4);
                    if (infoStructure == null) continue;
                    flow.addInfoStructure(infoStructure);
                }
            }
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(flow.getObjectID())).append(".dmd");
        flow.setFilePath(((StringBuffer)object).toString());
        return flow;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage() != null) {
                TransformationPackage transformationPackage = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage();
                String string2 = transformationPackage.getObjectID();
                String string3 = transformationPackage.getLastTaskAdded() != null ? transformationPackage.getLastTaskAdded().getObjectID() + "/" : "";
                stringBuffer.append(string).append('/');
                if (this.isOldDesign()) {
                    stringBuffer.append("processmodel/tansformationpackages");
                } else {
                    stringBuffer.append("pm/tp");
                    if (transformationPackage.getLastTaskAdded() != null) {
                        string3 = transformationPackage.getLastTaskAdded().getPathIDString() + "/";
                    }
                }
                stringBuffer.append('/').append(StringUtilities.decodeAttributeValue(string2)).append('/').append(StringUtilities.decodeAttributeValue(string3));
            }
        }
        stringBuffer.append(this.getConfiguration().get("flowPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == TransformationFlow.class;
    }
}

