/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformation
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLTransformation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getTransformationPackage().getLastTaskAdded().createTransformation(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        String string;
        String string2;
        Object object;
        Transformation transformation = (Transformation)super.recreateObject(element, design, bl);
        NodeList nodeList = element.getElementsByTagName("primary");
        if (nodeList.getLength() > 0) {
            object = (Element)nodeList.item(0);
            string2 = object.getAttribute("is_primary");
            if (string2 != null && string2.equals(VALUE_TRUE)) {
                transformation.setPrimary(true);
            } else {
                transformation.setPrimary(false);
            }
        }
        if ((string2 = (String)(object = this.getProperties(element, "attributes")).get("filter_condition")) != null) {
            transformation.setFilterCondition(string2);
        }
        if ((string = (String)object.get("join_condition")) != null) {
            transformation.setJoinCondition(string);
        }
        NodeList nodeList2 = RXMLTransformation.getFirstChildByTagName(element, "contained").getElementsByTagName("targetelement");
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            Object object2;
            Element element2 = (Element)nodeList2.item(i);
            object = new TreeMap<String, String>();
            NodeList nodeList3 = element2.getElementsByTagName("parameter");
            int n2 = nodeList3.getLength();
            for (int j = 0; j < n2; ++j) {
                object2 = (Element)nodeList3.item(j);
                object.put(object2.getAttribute("name"), object2.getAttribute("value"));
            }
            String string3 = (String)object.get("flowid");
            object2 = (String)object.get("attributeid");
            DesignObject designObject = transformation.getDesign().getLogicalDesign().getAttributeSet().getObjectByID((String)object2);
            if (designObject == null) {
                designObject = transformation.getDesign().getProcessModel().getExternalDataSet().getObjectByID((String)object2);
            }
            if (designObject == null) {
                designObject = transformation.getDesign().getProcessModel().getTransformationTask().getParameterObjectById((String)object2);
            }
            if ("".equalsIgnoreCase(string3) || designObject == null) continue;
            TargetElement targetElement = new TargetElement(designObject);
            transformation.getTargetElements().add(targetElement);
            String string4 = (String)object.get("type");
            targetElement.setTransformationType(string4);
            String string5 = (String)object.get("description");
            targetElement.setDescription(string5);
            String string6 = (String)object.get("sources");
            StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken();
                designObject = transformation.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string7);
                if (designObject != null) {
                    targetElement.addSource(designObject);
                    continue;
                }
                ExternalData externalData = (ExternalData)transformation.getDesign().getProcessModel().getExternalDataSet().getObjectByID(string7);
                if (externalData != null) {
                    targetElement.addSource(externalData);
                    continue;
                }
                ParameterObject parameterObject = transformation.getDesign().getProcessModel().getTransformationTask().getParameterObjectById(string7);
                targetElement.addSource(parameterObject);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(transformation.getObjectID())).append(".dmd");
        transformation.setFilePath(stringBuffer.toString());
        return transformation;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage() != null) {
                String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getObjectID();
                String string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getLastTaskAdded().getObjectID();
                stringBuffer.append(string).append('/');
                if (this.isOldDesign()) {
                    stringBuffer.append("processmodel/tansformationpackages");
                } else {
                    stringBuffer.append("pm/tp");
                    string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getLastTaskAdded().getPathIDString();
                }
                stringBuffer.append('/').append(string2).append('/').append(string3).append('/');
            } else {
                stringBuffer.append(string).append('/');
                if (this.isOldDesign()) {
                    stringBuffer.append("processmodel/tansformationpackages");
                } else {
                    stringBuffer.append("pm/tp");
                }
                stringBuffer.append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("processPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz != Process.class && clazz == Transformation.class;
    }
}

