/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLProcess
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLProcess(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getDataFlowDesign().getProcessSet().createProcess(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        ModelIDObject modelIDObject;
        String string;
        int n;
        String string2;
        Object object;
        Process process = (Process)super.recreateObject(element, design, bl);
        String string3 = element.getAttribute("synonym");
        if (string3 != null) {
            process.setSynonym(StringUtilities.decodeAttributeValue(string3));
        }
        TreeMap<String, String> treeMap = this.getProperties(element, "attributes");
        try {
            int n2 = Integer.parseInt((String)treeMap.get("type"));
            process.setType(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = (String)treeMap.get("diagram");
        if (!"null".equalsIgnoreCase(string4) && (object = (DataFlowDesign)process.getDesign().getProcessModel().getDataFlowDesigns().getById(string4)) != null) {
            process.setDiagram((DataFlowDesign)object);
            ((DataFlowDesign)object).setProcess(process);
        }
        if ((object = (String)treeMap.get("filter_condition")) != null) {
            process.setFilterCondition((String)object);
        }
        if ((string2 = (String)treeMap.get("join_condition")) != null) {
            process.setJoinCondition(string2);
        }
        process.setFootNote((String)treeMap.get("footnote"));
        try {
            n = Integer.parseInt((String)treeMap.get("frequencytimes"));
            process.setFrequencyTimes(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        process.setFrequencyTimeUnit((String)treeMap.get("frequencytimeunit"));
        process.setPriority((String)treeMap.get("priority"));
        process.setMode((String)treeMap.get("mode"));
        try {
            n = Integer.parseInt((String)treeMap.get("batchmintransactions"));
            process.setBatchMinimumTransactions(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        process.setBatchTimeUnit((String)treeMap.get("batchtimeunit"));
        try {
            int n3 = Integer.parseInt((String)treeMap.get("longestresponsetime"));
            process.setInteractiveLongestResponseTime(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        process.setInteractiveResponseTimeUnit((String)treeMap.get("responsetimeunit"));
        String string5 = (String)treeMap.get("peakperiods");
        if (string5 != null && !"".equalsIgnoreCase(string5) && string5.length() == process.getPeakPeriods().length) {
            for (int i = 0; i < string5.length(); ++i) {
                char c = string5.charAt(i);
                process.getPeakPeriods()[i] = "1".equalsIgnoreCase(String.valueOf(c));
            }
        }
        Map map = this.getProperties(element, "events");
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)map.get(objectArray[i]);
            modelIDObject = (Event)process.getDesign().getProcessModel().getEventSet().getObjectByID(string);
            if (modelIDObject == null) continue;
            process.addEvent((Event)modelIDObject);
            ((Event)modelIDObject).addProcess(process);
        }
        String string6 = (String)treeMap.get("trtask_input_params");
        process.setParamsWrappersString(string6);
        string = (String)treeMap.get("transformation_task");
        modelIDObject = process.getDesign().getProcessModel().getTransformationTaskById(string);
        if (modelIDObject != null) {
            process.setTransformationTask((TransformationTask)modelIDObject);
        }
        NodeList nodeList = RXMLProcess.getFirstChildByTagName(element, "contained").getElementsByTagName("targetelement");
        int n4 = nodeList.getLength();
        for (int i = 0; i < n4; ++i) {
            Object object2;
            Element element2 = (Element)nodeList.item(i);
            treeMap = new TreeMap<String, String>();
            NodeList nodeList2 = element2.getElementsByTagName("parameter");
            int n5 = nodeList2.getLength();
            for (int j = 0; j < n5; ++j) {
                object2 = (Element)nodeList2.item(j);
                treeMap.put(object2.getAttribute("name"), object2.getAttribute("value"));
            }
            String string7 = (String)treeMap.get("flowid");
            object2 = (String)treeMap.get("attributeid");
            DesignObject designObject = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID((String)object2);
            if (designObject == null) {
                designObject = process.getDesign().getProcessModel().getExternalDataSet().getObjectByID((String)object2);
            }
            if ("".equalsIgnoreCase(string7) || designObject == null) continue;
            TargetElement targetElement = new TargetElement(designObject);
            process.getTargetElements().add(targetElement);
            String string8 = (String)treeMap.get("type");
            targetElement.setTransformationType(string8);
            String string9 = (String)treeMap.get("description");
            targetElement.setDescription(string9);
            String string10 = (String)treeMap.get("sources");
            StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
            while (stringTokenizer.hasMoreTokens()) {
                TransformationTask transformationTask;
                ParameterObject parameterObject;
                String string11 = stringTokenizer.nextToken();
                designObject = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string11);
                if (designObject != null) {
                    targetElement.addSource(designObject);
                    continue;
                }
                ExternalData externalData = (ExternalData)process.getDesign().getProcessModel().getExternalDataSet().getObjectByID(string11);
                if (externalData != null) {
                    targetElement.addSource(externalData);
                    continue;
                }
                if (process.getTransformationTask() == null || (parameterObject = (transformationTask = process.getTransformationTask()).getParameterObjectById(string11)) == null) continue;
                targetElement.addSource(parameterObject);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(process.getObjectID())).append(".dmd");
        process.setFilePath(stringBuffer.toString());
        return process;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getDataFlowDesign().getObjectID();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("processmodel/dataflows");
            } else {
                stringBuffer.append("pm/dflows");
            }
            stringBuffer.append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("processPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Process.class && clazz != Transformation.class;
    }
}

