/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLInfoStructure
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLInfoStructure(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getInfoStructureSet().createInfoStructure(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        int n;
        InfoStructure infoStructure = (InfoStructure)super.recreateObject(element, design, bl);
        String string = element.getAttribute("synonym");
        if (string != null) {
            infoStructure.setSynonym(StringUtilities.decodeAttributeValue(string));
        }
        Map map = this.getProperties(element, "attributes");
        try {
            n = Integer.parseInt((String)map.get("volume"));
            infoStructure.setVolume(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = Integer.parseInt((String)map.get("growthRatePercent"));
            infoStructure.setGrowthRatePercent(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        infoStructure.setGrowthRateUnit((String)map.get("growthRateUnit"));
        Element element2 = RXMLInfoStructure.getFirstChildByTagName(element, "isattributes");
        if (element2 != null) {
            object = this.getProperties(element, "isattributes");
            Object[] objectArray = object.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)object.get(objectArray[i]);
                Attribute attribute = (Attribute)infoStructure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string2);
                if (attribute == null) continue;
                infoStructure.addAttribute(attribute);
            }
        } else {
            object = (String)map.get("isattributes");
            if (object != null) {
                String[] stringArray = ((String)object).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    Attribute attribute = (Attribute)infoStructure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string3);
                    if (attribute == null) continue;
                    infoStructure.addAttribute(attribute);
                }
            }
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(infoStructure.getObjectID())).append(".dmd");
        infoStructure.setFilePath(((StringBuffer)object).toString());
        return infoStructure;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                stringBuffer.append(string).append('/').append("processmodel").append('/');
            } else {
                stringBuffer.append(string).append('/').append("pm").append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("infoStructurePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == InfoStructure.class;
    }
}

