/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLAgent
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLAgent(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getDataFlowDesign().getExternalAgentSet().createExternalAgent(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        ExternalAgent externalAgent = (ExternalAgent)super.recreateObject(element, design, bl);
        String string = element.getAttribute("synonym");
        if (string != null) {
            externalAgent.setSynonym(StringUtilities.decodeAttributeValue(string));
        }
        Map map = this.getProperties(element, "attributes");
        try {
            int n = Integer.parseInt((String)map.get("type"));
            externalAgent.setType(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        externalAgent.setOwner(StringUtilities.decodeAttributeValue((String)map.get("agentowner")));
        externalAgent.setSource(StringUtilities.decodeAttributeValue((String)map.get("agentsource")));
        externalAgent.setFileName(StringUtilities.decodeAttributeValue((String)map.get("filename")));
        externalAgent.setLocation(StringUtilities.decodeAttributeValue((String)map.get("location")));
        externalAgent.setFileType(StringUtilities.decodeAttributeValue((String)map.get("filetype")));
        externalAgent.setFieldSeparator(StringUtilities.decodeAttributeValue((String)map.get("fieldseparator")));
        externalAgent.setTransferType(StringUtilities.decodeAttributeValue((String)map.get("transfertype")));
        externalAgent.setSelfDescribing(new Boolean((String)map.get("selfDescribing")));
        if (map.get("skipRecords") != null) {
            externalAgent.setSkipRecords(new Integer((String)map.get("skipRecords")));
        }
        externalAgent.setTextDelimiter((String)map.get("textDelimiter"));
        Map map2 = this.getProperties(element, "agentextdatas");
        Object[] objectArray = map2.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)map2.get(objectArray[i]);
            ExternalData externalData = (ExternalData)externalAgent.getDesign().getProcessModel().getExternalDataSet().getObjectByID(string2);
            if (externalData == null) continue;
            externalAgent.addExternalData(externalData);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(externalAgent.getObjectID())).append(".dmd");
        externalAgent.setFilePath(stringBuffer.toString());
        return externalAgent;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getDataFlowDesign().getObjectID();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("processmodel/dataflows");
            } else {
                stringBuffer.append("pm/dflows");
            }
            stringBuffer.append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("agentPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == ExternalAgent.class;
    }
}

