/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLSlice
extends AbstractWXMLDesignObject
implements MDConstants {
    private Slice slice = null;

    public WXMLSlice(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Slice;
        if (bl) {
            this.slice = (Slice)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.slice != null) {
            String string = this.slice.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.slice.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("slicePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Slice) {
            Slice slice = (Slice)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(slice.getDescription()));
            treeMap.put("readonly", String.valueOf(slice.isReadOnlySlice()));
            treeMap.put("fullyrealized", String.valueOf(slice.isFullyRealized()));
            treeMap.put("entity", String.valueOf(slice.getEntity() != null ? StringUtilities.encodeAttributeValue(slice.getEntity().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, slice.getLevels().toArray(), "levels");
            this.appendObjects(element, slice.getSelectionCriterias().toArray(), "selectioncriterias");
            Element element2 = element.getOwnerDocument().createElement("measure_wrappers");
            this.appendMeasureWrappers(element2, slice);
            element.appendChild(element2);
            Element element3 = element.getOwnerDocument().createElement("selected_levels");
            this.appendSelectedLevels(element3, slice);
            element.appendChild(element3);
            this.appendSliceMappings(element, slice);
        }
    }

    private void appendMeasureWrappers(Element element, Slice slice) {
        for (Slice.MeasureWrapper measureWrapper : slice.getSelectedMeasureWrappers()) {
            Element element2 = element.getOwnerDocument().createElement("measure_wrapper");
            if (measureWrapper.getMeasure() != null) {
                element2.setAttribute("measure_id", StringUtilities.encodeAttributeValue(measureWrapper.getMeasure().getObjectID()));
            }
            if (measureWrapper.getAggrFunction() != null) {
                element2.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(measureWrapper.getAggrFunction().getObjectID()));
            }
            this.appendSummaryLevels(element2, measureWrapper);
            element.appendChild(element2);
        }
    }

    private void appendSummaryLevels(Element element, Slice.MeasureWrapper measureWrapper) {
        for (Level level : measureWrapper.levels) {
            Element element2 = element.getOwnerDocument().createElement("summary_level");
            element2.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            element.appendChild(element2);
        }
    }

    private void appendSelectedLevels(Element element, Slice slice) {
        for (Slice.SelectedLevel selectedLevel : slice.getSelectedLevels()) {
            Element element2 = element.getOwnerDocument().createElement("selected_level");
            element2.setAttribute("dimension_id", StringUtilities.encodeAttributeValue(selectedLevel.getDimension().getObjectID()));
            element2.setAttribute("hierarchy_id", StringUtilities.encodeAttributeValue(selectedLevel.getHierarchy().getObjectID()));
            element2.setAttribute("level_id", StringUtilities.encodeAttributeValue(selectedLevel.getLevel().getObjectID()));
            element2.setAttribute("selected_attributes", selectedLevel.getSelAttrIDs());
            if (selectedLevel.rollupLink != null) {
                element2.setAttribute("rolluplink", StringUtilities.encodeAttributeValue(selectedLevel.rollupLink.getObjectID()));
            }
            element.appendChild(element2);
        }
    }

    private void appendSliceMappings(Element element, Slice slice) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("slice_mappings");
        for (Slice.SliceMapping sliceMapping : slice.getSliceMappings()) {
            Element element3 = document.createElement("contained");
            element3.setAttribute("oid", StringUtilities.encodeAttributeValue(sliceMapping.getAttribute().getObjectID()));
            element3.setAttribute("mappingid", sliceMapping.getMapping() != null ? StringUtilities.encodeAttributeValue(sliceMapping.getMapping().getObjectID()) : "");
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

