/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLSelectionCriteria
extends AbstractWXMLDesignObject
implements MDConstants {
    private SelectionCriteria sc = null;

    public WXMLSelectionCriteria(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof SelectionCriteria;
        if (bl) {
            this.sc = (SelectionCriteria)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sc != null) {
            String string = this.sc.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.sc.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("selcriteriaPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof SelectionCriteria) {
            SelectionCriteria selectionCriteria = (SelectionCriteria)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("selectioncriteria", String.valueOf(selectionCriteria.getSelectionCriteria()));
            treeMap.put("description", String.valueOf(selectionCriteria.getDescription()));
            treeMap.put("entity", String.valueOf(selectionCriteria.getEntity() != null ? StringUtilities.encodeAttributeValue(selectionCriteria.getEntity().getObjectID()) : "null"));
            treeMap.put("partition", String.valueOf(selectionCriteria.getPartition()));
            treeMap.put("measure_id", String.valueOf(selectionCriteria.getMeasureWrapper() != null ? StringUtilities.encodeAttributeValue(selectionCriteria.getMeasureWrapper().getMeasure().getObjectID()) : "null"));
            treeMap.put("aggr_function_id", String.valueOf(selectionCriteria.getMeasureWrapper() != null ? StringUtilities.encodeAttributeValue(selectionCriteria.getMeasureWrapper().getAggrFunction().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

