/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLSQLAccessToAW
extends AbstractWXMLDesignObject
implements MDConstants {
    private SQLAccessToAW awSQL = null;
    private Slice slice;
    private Cube cube;

    public WXMLSQLAccessToAW(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof SQLAccessToAW;
        if (bl) {
            this.awSQL = (SQLAccessToAW)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.awSQL != null) {
            String string = this.awSQL.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.awSQL.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("sqltoawPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof SQLAccessToAW) {
            Element element2;
            this.awSQL = (SQLAccessToAW)designObject;
            this.awSQL.verifyDefinitions();
            this.cube = this.awSQL.getCube();
            this.slice = this.awSQL.getSlice();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(this.awSQL.getDescription()));
            treeMap.put("aw_name", String.valueOf(this.awSQL.getAWName()));
            treeMap.put("aw_include_gids", String.valueOf(this.awSQL.isGenerateGIDs()));
            treeMap.put("aw_use_object_types", String.valueOf(this.awSQL.isUseObjectType()));
            treeMap.put("aw_use_model_clause", String.valueOf(this.awSQL.isUseModelClause()));
            treeMap.put("aw_include_row2cell", String.valueOf(this.awSQL.isUseRowToCellColumn()));
            treeMap.put("aw_object_type_name", String.valueOf(this.awSQL.getObjectADTName()));
            treeMap.put("aw_table_type_name", String.valueOf(this.awSQL.getTableADTName()));
            if (this.slice != null) {
                treeMap.put("slice_id", StringUtilities.encodeAttributeValue(this.slice.getObjectID()));
            } else {
                treeMap.put("cube_id", StringUtilities.encodeAttributeValue(this.cube.getObjectID()));
            }
            this.appendProperties(element, "attributes", treeMap);
            if (this.slice != null) {
                element2 = element.getOwnerDocument().createElement("measure_wrappers");
                this.appendMeasureWrappers(element2, this.awSQL);
                element.appendChild(element2);
            } else {
                this.appendObjects(element, this.awSQL.getMeasures().toArray(), "measures");
            }
            element2 = element.getOwnerDocument().createElement("aw_out_sql_attributes");
            this.appendOutAttributes(element2, this.awSQL);
            element.appendChild(element2);
            Element element3 = element.getOwnerDocument().createElement("aw_sql_dimensions");
            this.appendSQLDimensions(element3, this.awSQL);
            element.appendChild(element3);
        }
    }

    private void appendOutAttributes(Element element, SQLAccessToAW sQLAccessToAW) {
        for (SQLAttribute sQLAttribute : this.getOtherOutAttributes()) {
            this.appendSQLAttribute(element, sQLAttribute);
        }
    }

    private void appendMeasureWrappers(Element element, SQLAccessToAW sQLAccessToAW) {
        if (this.slice != null) {
            for (Slice.MeasureWrapper measureWrapper : sQLAccessToAW.getMeasureWrappers()) {
                Element element2 = element.getOwnerDocument().createElement("measure_wrapper");
                element2.setAttribute("measure_id", StringUtilities.encodeAttributeValue(measureWrapper.getMeasure().getObjectID()));
                if (measureWrapper.getAggrFunction() != null) {
                    element2.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(measureWrapper.getAggrFunction().getObjectID()));
                }
                element.appendChild(element2);
            }
        }
    }

    private void appendSQLDimensions(Element element, SQLAccessToAW sQLAccessToAW) {
        for (SQLAccessToAW.SQLDimension sQLDimension : sQLAccessToAW.getSqlDimensionDefinitions()) {
            Element element2 = element.getOwnerDocument().createElement("aw_sqldimension");
            this.appendSQLDimension(element2, sQLDimension);
            element.appendChild(element2);
        }
    }

    private void appendSQLDimension(Element element, SQLAccessToAW.SQLDimension sQLDimension) {
        Object object;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("aw_use_long_desc", String.valueOf(sQLDimension.isSelectedLongDescAttr()));
        treeMap.put("aw_use_short_desc", String.valueOf(sQLDimension.isSelectedShortDescAttr()));
        treeMap.put("aw_use_level_name", String.valueOf(sQLDimension.isSelectedLevelNameAttr()));
        treeMap.put("aw_use_dim_column", String.valueOf(sQLDimension.isSelectedDimensionID()));
        treeMap.put("dimension_id", String.valueOf(StringUtilities.encodeAttributeValue(sQLDimension.getDimension().getObjectID())));
        this.appendProperties(element, "aw_sqldim_attributes", treeMap);
        Iterator iterator = sQLDimension.getAllSelectedAttributes().iterator();
        Element element2 = element.getOwnerDocument().createElement("aw_sql_attributes");
        while (iterator.hasNext()) {
            object = (SQLAttribute)iterator.next();
            this.appendSQLAttribute(element2, (SQLAttribute)object);
        }
        element.appendChild(element2);
        object = element.getOwnerDocument().createElement("aw_hierarchies");
        for (SQLAccessToAW.SQLHierarchy sQLHierarchy : sQLDimension.getSelectedSQLHierarhies()) {
            this.appendSQLHierarchy((Element)object, sQLHierarchy);
        }
        element.appendChild((Node)object);
    }

    private List getOtherOutAttributes() {
        ArrayList<SQLAttribute> arrayList = new ArrayList<SQLAttribute>();
        for (SQLAttribute sQLAttribute : this.awSQL.getOutSQLAttributes()) {
            if (!SQLAccessToAW.ATTR_TYPE_MEASURE.equals(sQLAttribute.getType())) continue;
            arrayList.add(sQLAttribute);
        }
        return arrayList;
    }

    private void appendSQLAttribute(Element element, SQLAttribute sQLAttribute) {
        Element element2 = element.getOwnerDocument().createElement("aw_sql_attribute");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("name", sQLAttribute.getName());
        treeMap.put("type", sQLAttribute.getType());
        treeMap.put("datatype", sQLAttribute.getDataType());
        treeMap.put("aw_sql_attr_out_position", String.valueOf(sQLAttribute.getOutPosition()));
        if (sQLAttribute.getHierarchy() != null) {
            treeMap.put("hierarchy_id", StringUtilities.encodeAttributeValue(sQLAttribute.getHierarchy().getObjectID()));
        }
        if (sQLAttribute.getLevel() != null) {
            treeMap.put("level_id", StringUtilities.encodeAttributeValue(sQLAttribute.getLevel().getObjectID()));
        }
        if (sQLAttribute.getCube() != null) {
            treeMap.put("cube_id", StringUtilities.encodeAttributeValue(sQLAttribute.getCube().getObjectID()));
        }
        if (sQLAttribute.getSlice() != null) {
            treeMap.put("slice_id", StringUtilities.encodeAttributeValue(sQLAttribute.getSlice().getObjectID()));
        }
        if (sQLAttribute.getMeasure() != null) {
            treeMap.put("measure", StringUtilities.encodeAttributeValue(sQLAttribute.getMeasure().getObjectID()));
        }
        if (sQLAttribute.getMeasureWrapper() != null) {
            treeMap.put("measure_wrapper", StringUtilities.encodeAttributeValue(sQLAttribute.getMeasureWrapper().getMeasure().getObjectID()));
            treeMap.put("aggr_function_id", StringUtilities.encodeAttributeValue(sQLAttribute.getMeasureWrapper().getAggrFunction().getObjectID()));
        }
        if (sQLAttribute.getSlowChangingAttribute() != null) {
            treeMap.put("attribute", StringUtilities.encodeAttributeValue(sQLAttribute.getSlowChangingAttribute().getAttribute().getObjectID()));
            treeMap.put("scattribute_name", sQLAttribute.getSlowChangingAttribute().getName());
        }
        treeMap.put("aw_isname_editable", String.valueOf(sQLAttribute.isNameEditable()));
        this.appendProperties(element2, "aw_sql_attribute_props", treeMap);
        element.appendChild(element2);
    }

    private void appendSQLHierarchy(Element element, SQLAccessToAW.SQLHierarchy sQLHierarchy) {
        Element element2 = element.getOwnerDocument().createElement("aw_hierarchy");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("hierarchy_id", StringUtilities.encodeAttributeValue(sQLHierarchy.getHierarchy().getObjectID()));
        treeMap.put("aw_is_rollupform", String.valueOf(sQLHierarchy.isRollupForm()));
        this.appendProperties(element2, "attributes", treeMap);
        if (sQLHierarchy.getLabelAttribute() != null) {
            this.appendSQLAttribute(element2, sQLHierarchy.getLabelAttribute());
        }
        this.appendObjects(element2, sQLHierarchy.getSelectedLevels().toArray(), "levels");
        element.appendChild(element2);
    }
}

