/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLMeasure
extends AbstractWXMLDesignObject
implements MDConstants {
    private Measure measure = null;

    public WXMLMeasure(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Measure;
        if (bl) {
            this.measure = (Measure)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.measure != null) {
            String string = this.measure.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.measure.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("measurePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Measure) {
            Measure measure = (Measure)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(measure.getDescription()));
            treeMap.put("isformula", String.valueOf(measure.isFormula()));
            treeMap.put("is_custom_formula", String.valueOf(measure.isCustomFormula()));
            treeMap.put("formula", String.valueOf(measure.getFormula()));
            treeMap.put("aw_formula_type", String.valueOf(measure.getOracleAWFormulaType()));
            treeMap.put("act_as_fact_dimension", String.valueOf(measure.isActAsFactDimension()));
            treeMap.put("aggregation_function", String.valueOf(measure.getDefaultAggregationFunction()));
            treeMap.put("where_clause", measure.getWhereClause());
            treeMap.put("additivity", measure.getAdditivity());
            this.appendOLAPMeasureProperties(measure, treeMap);
            if (!measure.isFormula() && measure.getMeasureFact() != null) {
                treeMap.put("measure_fact", StringUtilities.encodeAttributeValue(measure.getMeasureFact().getObjectID()));
            }
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, measure.getAttributes().toArray(), "attributes_list");
            Element element2 = element.getOwnerDocument().createElement("aggregation_functions");
            this.appendAggrFunctions(element2, measure);
            element.appendChild(element2);
        }
    }

    private void appendOLAPMeasureProperties(Measure measure, Map map) {
        map.put("aw_operator", String.valueOf(measure.getOLAPOperator()));
        map.put("aw_offset", String.valueOf(measure.getOLAPOffset()));
        map.put("aw_start", String.valueOf(measure.getOLAPStart()));
        map.put("aw_step", String.valueOf(measure.getOLAPStep()));
        map.put("aw_stop", String.valueOf(measure.getOLAPStop()));
        map.put("aw_pd_operation", String.valueOf(measure.getOLAPPeriodToDateOperation()));
        map.put("aw_rank_direction", String.valueOf(measure.getRankDirectionCode()));
        if (measure.getOLAPDimension() != null) {
            map.put("aw_dimension", StringUtilities.encodeAttributeValue(measure.getOLAPDimension().getObjectID()));
        }
        if (measure.getOLAPHierarchy() != null) {
            map.put("aw_hierarchy", StringUtilities.encodeAttributeValue(measure.getOLAPHierarchy().getObjectID()));
        }
        if (measure.getOLAPLevel() != null) {
            map.put("aw_level", StringUtilities.encodeAttributeValue(measure.getOLAPLevel().getObjectID()));
        }
        if (measure.getUsedOLAPMeasure() != null) {
            map.put("aw_measure", StringUtilities.encodeAttributeValue(measure.getUsedOLAPMeasure().getObjectID()));
        }
    }

    private void appendAggrFunctions(Element element, Measure measure) {
        for (Measure.AggregateFunction aggregateFunction : measure.getAggregateFunctions()) {
            Element element2 = element.getOwnerDocument().createElement("aggregation_function");
            element2.setAttribute("id", StringUtilities.encodeAttributeValue(aggregateFunction.getObjectID()));
            element2.setAttribute("function", aggregateFunction.name);
            element2.setAttribute("measure_alias", aggregateFunction.measureAlias);
            boolean bl = aggregateFunction == measure.getDefaultAggregationFunction();
            element2.setAttribute("default", String.valueOf(bl));
            Iterator iterator = aggregateFunction.dimensions.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
            }
            element2.setAttribute("dimensions", stringBuffer.toString());
            this.appendSummaryLevels(element2, aggregateFunction);
            element.appendChild(element2);
        }
    }

    private void appendSummaryLevels(Element element, Measure.AggregateFunction aggregateFunction) {
        for (Level level : aggregateFunction.levels) {
            Element element2 = element.getOwnerDocument().createElement("summary_level");
            element2.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            element.appendChild(element2);
        }
    }
}

