/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLHierarchy
extends AbstractWXMLDesignObject
implements MDConstants {
    private Hierarchy hierarchy = null;

    public WXMLHierarchy(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Hierarchy;
        if (bl) {
            this.hierarchy = (Hierarchy)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hierarchy != null) {
            String string = this.hierarchy.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.hierarchy.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("hierarchyPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", StringUtilities.encodeAttributeValue(String.valueOf(hierarchy.getDescription())));
            treeMap.put("default_hierarchy", String.valueOf(hierarchy.isDefaultHierarchy()));
            treeMap.put("link_to_dimension", StringUtilities.encodeAttributeValue(hierarchy.getLinkToDimension().getObjectID()));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, hierarchy.getLevels().toArray(), "levels");
            this.appendObjects(element, hierarchy.getLinks().toArray(), "links");
        }
    }
}

