/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSlice
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLSlice(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getSliceSet().createSlice(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        AbstractMDObject abstractMDObject;
        String string;
        int n;
        Object object;
        Slice slice = (Slice)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        slice.setDescription((String)map.get("description"));
        slice.setReadOnlySlice(Boolean.valueOf((String)map.get("readonly")));
        slice.setFullyRealized(Boolean.valueOf((String)map.get("fullyrealized")));
        String string2 = (String)map.get("entity");
        if (!"null".equalsIgnoreCase(string2) && (object = (Entity)slice.getDesign().getLogicalDesign().getEntitySet().getObjectByID(string2)) != null) {
            slice.setEntity((Entity)object);
        }
        object = this.getProperties(element, "levels");
        Object[] objectArray = object.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)object.get(objectArray[n]);
            abstractMDObject = (Level)slice.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID(string);
            if (abstractMDObject == null) continue;
            slice.addLevel((Level)abstractMDObject);
        }
        object = this.getProperties(element, "selectioncriterias");
        objectArray = object.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)object.get(objectArray[n]);
            abstractMDObject = (SelectionCriteria)slice.getDesign().getMultidimensionalDesign().getSelectionCriteriaSet().getObjectByID(string);
            if (abstractMDObject == null) continue;
            ((SelectionCriteria)abstractMDObject).setSlice(slice);
            slice.addSelectionCriteria((SelectionCriteria)abstractMDObject);
        }
        this.handleAggrFunctions(element, slice);
        this.handleSelectedLevels(element, slice);
        this.handleSliceMappings(element, slice);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(slice.getObjectID())).append(".dmd");
        slice.setFilePath(stringBuffer.toString());
        return slice;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("slicePath"));
        return stringBuffer.toString();
    }

    private void handleAggrFunctions(Element element, Slice slice) {
        Element element2 = RXMLSlice.getFirstChildByTagName(element, "measure_wrappers");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("measure_wrapper");
            int n = nodeList.getLength();
            List list = slice.getSelectedMeasureWrappers();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("measure_id");
                String string2 = element3.getAttribute("aggr_function_id");
                Slice.MeasureWrapper measureWrapper = slice.createMeasureWrapper(string, string2);
                this.handleSummaryLevels(element3, measureWrapper, slice);
                list.add(measureWrapper);
            }
        }
    }

    private void handleSummaryLevels(Element element, Slice.MeasureWrapper measureWrapper, Slice slice) {
        NodeList nodeList = element.getElementsByTagName("summary_level");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("level_id");
            Level level = (Level)((MultidimensionalDesign)slice.getDesignPart()).getLevelSet().getObjectByID(string);
            if (level == null) continue;
            measureWrapper.levels.add(level);
        }
    }

    private void handleSelectedLevels(Element element, Slice slice) {
        Element element2 = RXMLSlice.getFirstChildByTagName(element, "selected_levels");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("selected_level");
            int n = nodeList.getLength();
            List list = slice.getSelectedLevels();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("dimension_id");
                String string2 = element3.getAttribute("hierarchy_id");
                String string3 = element3.getAttribute("level_id");
                String string4 = element3.getAttribute("selected_attributes");
                String string5 = element3.getAttribute("rolluplink");
                Slice slice2 = slice;
                slice2.getClass();
                Slice.SelectedLevel selectedLevel = slice2.new Slice.SelectedLevel(string, string2, string3, slice);
                if (string4 != null) {
                    selectedLevel.setSelAttrIDs(string4);
                }
                if (string5 != null) {
                    selectedLevel.rollupLink = (RollupLink)((MultidimensionalDesign)slice.getDesignPart()).getRollupLinkSet().getObjectByID(string5);
                }
                list.add(selectedLevel);
            }
        }
    }

    private void handleSliceMappings(Element element, Slice slice) {
        Element element2;
        if (slice.getEntity() != null && (element2 = RXMLSlice.getFirstChildByTagName(element, "slice_mappings")) != null) {
            NodeList nodeList = element2.getElementsByTagName("contained");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                DesignObject designObject;
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("oid");
                String string2 = element3.getAttribute("mappingid");
                Attribute attribute = (Attribute)slice.getEntity().getElementByID(string);
                if (attribute == null || (designObject = slice.getDesign().getDesignObject(string2)) == null) continue;
                Slice slice2 = slice;
                slice2.getClass();
                Slice.SliceMapping sliceMapping = slice2.new Slice.SliceMapping(attribute, designObject);
                slice.getSliceMappings().add(sliceMapping);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Slice.class;
    }
}

