/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSQLAccessToAW
extends AbstractRXMLDesignObject
implements MDConstants {
    private Cube cube;
    private Slice slice;
    private boolean hasOutPosition = true;
    private TreeMap posMap = new TreeMap();

    public RXMLSQLAccessToAW(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getSQLAccessToAWSet().createSQLAccessToAW(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        int n;
        Object object2;
        this.hasOutPosition = true;
        this.slice = null;
        this.cube = null;
        SQLAccessToAW sQLAccessToAW = (SQLAccessToAW)super.recreateObject(element, design, bl);
        this.posMap.clear();
        Map map = this.getProperties(element, "attributes");
        sQLAccessToAW.setDescription((String)map.get("description"));
        sQLAccessToAW.setAWName((String)map.get("aw_name"));
        sQLAccessToAW.setGenerateGIDs(Boolean.valueOf((String)map.get("aw_include_gids")));
        sQLAccessToAW.setUseObjectType(Boolean.valueOf((String)map.get("aw_use_object_types")));
        sQLAccessToAW.setUseModelClause(Boolean.valueOf((String)map.get("aw_use_model_clause")));
        sQLAccessToAW.setUseRowToCellColumn(Boolean.valueOf((String)map.get("aw_include_row2cell")));
        sQLAccessToAW.setObjectADTName((String)map.get("aw_object_type_name"));
        sQLAccessToAW.setTableADTName((String)map.get("aw_table_type_name"));
        String string = (String)map.get("cube_id");
        if (string != null) {
            this.cube = (Cube)sQLAccessToAW.getMultidimensionalDesign().getCubeSet().getObjectByID(string);
            if (this.cube != null) {
                this.cube.getSQLDefinitions().add(sQLAccessToAW);
                sQLAccessToAW.setCube(this.cube);
            }
        } else {
            object2 = (Object[])map.get("slice_id");
            this.slice = (Slice)sQLAccessToAW.getMultidimensionalDesign().getSliceSet().getObjectByID((String)object2);
            if (this.slice != null) {
                this.slice.getSQLDefinitions().add(sQLAccessToAW);
                sQLAccessToAW.setSlice(this.slice);
            }
        }
        if (this.slice != null) {
            this.handleMeasureWrappers(element, sQLAccessToAW, this.slice);
        } else {
            map = this.getProperties(element, "measures");
            object2 = map.keySet().toArray();
            for (n = 0; n < ((Object[])object2).length; ++n) {
                object = (String)map.get(object2[n]);
                Measure measure = (Measure)this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID((String)object);
                if (measure == null) continue;
                sQLAccessToAW.getMeasures().add(measure);
            }
        }
        this.addOutAttributes(element, sQLAccessToAW);
        this.handleSQLDimensions(element, sQLAccessToAW);
        if (this.hasOutPosition) {
            sQLAccessToAW.getOutSQLAttributes().clear();
            for (Integer n2 : this.posMap.keySet()) {
                object = (SQLAttribute)this.posMap.get(n2);
                sQLAccessToAW.getOutSQLAttributes().add(object);
            }
        } else {
            object2 = sQLAccessToAW.getOutSQLAttributes();
            for (n = 0; n < object2.size(); ++n) {
                object = (SQLAttribute)object2.get(n);
                ((SQLAttribute)object).setOutPosition(n);
            }
        }
        return sQLAccessToAW;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("sqltoawPath"));
        return stringBuffer.toString();
    }

    private void handleMeasureWrappers(Element element, SQLAccessToAW sQLAccessToAW, Slice slice) {
        Element element2 = RXMLSQLAccessToAW.getFirstChildByTagName(element, "measure_wrappers");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("measure_wrapper");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Element element3 = (Element)nodeList.item(i);
                String string2 = element3.getAttribute("measure_id");
                Slice.MeasureWrapper measureWrapper = slice.getMeasureWrapper(string2, string = element3.getAttribute("aggr_function_id"));
                if (measureWrapper == null) continue;
                sQLAccessToAW.getMeasureWrappers().add(measureWrapper);
            }
        }
    }

    private void addHierarchies(Element element, SQLAccessToAW.SQLDimension sQLDimension, SQLAccessToAW sQLAccessToAW) {
        Element element2 = RXMLSQLAccessToAW.getFirstChildByTagName(element, "aw_hierarchies");
        List list = sQLDimension.getSelectedSQLHierarhies();
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("aw_hierarchy");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                Map map = this.getProperties(element3, "attributes");
                String string = (String)map.get("hierarchy_id");
                String string2 = (String)map.get("aw_is_rollupform");
                SQLAccessToAW sQLAccessToAW2 = sQLAccessToAW;
                sQLAccessToAW2.getClass();
                SQLAccessToAW.SQLHierarchy sQLHierarchy = sQLAccessToAW2.new SQLAccessToAW.SQLHierarchy(string);
                if ("true".equals(string2)) {
                    sQLHierarchy.setRollupForm(true);
                } else {
                    sQLHierarchy.setRollupForm(true);
                }
                map = this.getProperties(element3, "levels");
                Object[] objectArray = map.keySet().toArray();
                for (int j = 0; j < objectArray.length; ++j) {
                    String string3 = (String)map.get(objectArray[j]);
                    Level level = (Level)sQLAccessToAW.getMultidimensionalDesign().getLevelSet().getObjectByID(string3);
                    if (level == null) continue;
                    sQLHierarchy.getSelectedLevels().add(level);
                }
                list.add(sQLHierarchy);
            }
        }
    }

    private void handleSQLDimensions(Element element, SQLAccessToAW sQLAccessToAW) {
        Element element2 = RXMLSQLAccessToAW.getFirstChildByTagName(element, "aw_sql_dimensions");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("aw_sqldimension");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                this.addSQLDimension(element3, sQLAccessToAW);
            }
        }
    }

    private void addOutAttributes(Element element, SQLAccessToAW sQLAccessToAW) {
        Element element2 = RXMLSQLAccessToAW.getFirstChildByTagName(element, "aw_out_sql_attributes");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("aw_sql_attribute");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                this.addSQLAttribute(element3, sQLAccessToAW);
            }
        }
    }

    private void addSQLDimension(Element element, SQLAccessToAW sQLAccessToAW) {
        List list = sQLAccessToAW.getSqlDimensionDefinitions();
        Map map = this.getProperties(element, "aw_sqldim_attributes");
        String string = (String)map.get("dimension_id");
        Dimension dimension = (Dimension)sQLAccessToAW.getMultidimensionalDesign().getDimensionSet().getObjectByID(string);
        if (dimension != null) {
            SQLAccessToAW sQLAccessToAW2 = sQLAccessToAW;
            sQLAccessToAW2.getClass();
            SQLAccessToAW.SQLDimension sQLDimension = sQLAccessToAW2.new SQLAccessToAW.SQLDimension(dimension, sQLAccessToAW);
            this.addSQLAttributes(element, sQLDimension, sQLAccessToAW);
            this.addHierarchies(element, sQLDimension, sQLAccessToAW);
            list.add(sQLDimension);
        }
    }

    private void addSQLAttributes(Element element, SQLAccessToAW.SQLDimension sQLDimension, SQLAccessToAW sQLAccessToAW) {
        Element element2 = RXMLSQLAccessToAW.getFirstChildByTagName(element, "aw_sql_attributes");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("aw_sql_attribute");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                this.addSQLAttribute(element3, sQLDimension, sQLAccessToAW);
            }
        }
    }

    private void addSQLAttribute(Element element, SQLAccessToAW.SQLDimension sQLDimension, SQLAccessToAW sQLAccessToAW) {
        Object object;
        Dimension dimension = sQLDimension.getDimension();
        List list = sQLDimension.getAllSelectedAttributes();
        Map map = this.getProperties(element, "aw_sql_attribute_props");
        String string = (String)map.get("name");
        String string2 = (String)map.get("type");
        String string3 = (String)map.get("datatype");
        String string4 = (String)map.get("aw_sql_attr_out_position");
        SQLAttribute sQLAttribute = null;
        if (SQLAccessToAW.ATTR_TYPE_SHORT_DESC.equals(string2)) {
            sQLDimension.setSelectedShortDescAttr(true);
            sQLAttribute = sQLDimension.getShortDescAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_LONG_DESC.equals(string2)) {
            sQLDimension.setSelectedLongDescAttr(true);
            sQLAttribute = sQLDimension.getLongDescAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_END_DATE.equals(string2)) {
            sQLDimension.setSelectedEndDate(true);
            sQLAttribute = sQLDimension.getEndDateAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_TIME_SPAN.equals(string2)) {
            sQLDimension.setSelectedTimeSpan(true);
            sQLAttribute = sQLDimension.getTimeSpanAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_LEVEL_NAME.equals(string2)) {
            sQLDimension.setSelectedLevelNameAttr(true);
            sQLAttribute = sQLDimension.getLevelNameAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_ID.equals(string2)) {
            sQLDimension.setSelectedDimensionID(true);
            sQLAttribute = sQLDimension.getDimensionIDAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_GID.equals(string2)) {
            sQLAttribute = sQLDimension.getDimensionGIDAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_MEASURE.equals(string2)) {
            if (sQLAccessToAW.getSlice() != null) {
                object = (String)map.get("measure_wrapper");
                String string5 = (String)map.get("aggr_function_id");
                Slice.MeasureWrapper measureWrapper = sQLAccessToAW.getSlice().createMeasureWrapper((String)object, string5);
                if (measureWrapper != null) {
                    sQLAttribute = new SQLAttribute(measureWrapper.getMeasureAlias(), measureWrapper, sQLAccessToAW.getSlice());
                }
            } else {
                object = (String)map.get("measure");
                Measure measure = (Measure)sQLAccessToAW.getMultidimensionalDesign().getMeasureSet().getObjectByID((String)object);
                if (measure != null) {
                    sQLAttribute = new SQLAttribute(measure.getName(), measure, sQLAccessToAW.getCube());
                }
            }
        } else if (SQLAccessToAW.ATTR_TYPE_LEVEL.equals(string2)) {
            object = (String)map.get("level_id");
            String string6 = (String)map.get("hierarchy_id");
            Level level = (Level)sQLAccessToAW.getMultidimensionalDesign().getLevelSet().getObjectByID((String)object);
            if (level != null) {
                sQLAttribute = new SQLAttribute(level.getName(), dimension, string6, level);
            }
        } else if (SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR.equals(string2)) {
            object = (String)map.get("attribute");
            String string7 = (String)map.get("scattribute_name");
            String string8 = (String)map.get("level_id");
            Level level = (Level)sQLAccessToAW.getMultidimensionalDesign().getLevelSet().getObjectByID(string8);
            if (level != null) {
                SlowChangingAttribute slowChangingAttribute = level.getSlowChangingAttribute((String)object, string7);
                sQLAttribute = new SQLAttribute(level.getName(), dimension, level, slowChangingAttribute);
            }
        }
        if (sQLAttribute != null) {
            if (string != null) {
                sQLAttribute.setName(string);
            }
            if (string3 != null) {
                sQLAttribute.setDataType(string3);
            }
            if (string4 == null) {
                this.hasOutPosition = false;
            } else {
                object = Integer.valueOf(string4);
                sQLAttribute.setOutPosition((Integer)object);
                this.posMap.put(object, sQLAttribute);
            }
            list.add(sQLAttribute);
        }
    }

    private void addSQLAttribute(Element element, SQLAccessToAW sQLAccessToAW) {
        Object object;
        List list = sQLAccessToAW.getOutSQLAttributes();
        Map map = this.getProperties(element, "aw_sql_attribute_props");
        String string = (String)map.get("name");
        String string2 = (String)map.get("type");
        String string3 = (String)map.get("datatype");
        String string4 = (String)map.get("aw_sql_attr_out_position");
        SQLAttribute sQLAttribute = null;
        if (SQLAccessToAW.ATTR_TYPE_MEASURE.equals(string2)) {
            if (sQLAccessToAW.getSlice() != null) {
                object = (String)map.get("measure_wrapper");
                String string5 = (String)map.get("aggr_function_id");
                Slice.MeasureWrapper measureWrapper = sQLAccessToAW.getSlice().createMeasureWrapper((String)object, string5);
                if (measureWrapper != null) {
                    sQLAttribute = new SQLAttribute(measureWrapper.getMeasureAlias(), measureWrapper, sQLAccessToAW.getSlice());
                }
            } else {
                object = (String)map.get("measure");
                Measure measure = (Measure)sQLAccessToAW.getMultidimensionalDesign().getMeasureSet().getObjectByID((String)object);
                if (measure != null) {
                    sQLAttribute = new SQLAttribute(measure.getName(), measure, sQLAccessToAW.getCube());
                }
            }
        }
        if (sQLAttribute != null) {
            if (string != null) {
                sQLAttribute.setName(string);
            }
            if (string3 != null) {
                sQLAttribute.setDataType(string3);
            }
            if (string4 == null) {
                this.hasOutPosition = false;
            } else {
                object = Integer.valueOf(string4);
                sQLAttribute.setOutPosition((Integer)object);
                this.posMap.put(object, sQLAttribute);
            }
            list.add(sQLAttribute);
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == SQLAccessToAW.class;
    }
}

