/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRaggedHLink
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLRaggedHLink(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getRaggedHLinkSet().createRaggedHLink(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        Object object2;
        RaggedHLink raggedHLink = (RaggedHLink)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        raggedHLink.setDescription((String)map.get("description"));
        String string = (String)map.get("childlevel");
        if (!"null".equalsIgnoreCase(string) && (object2 = (Level)design.getDesignObject(string)) != null) {
            raggedHLink.setChildLevel((Level)object2);
            raggedHLink.setSourceMDObject((AbstractMDObject)object2);
        }
        if (!"null".equalsIgnoreCase((String)(object2 = (String)map.get("parentlevel"))) && (object = (Level)design.getDesignObject((String)object2)) != null) {
            raggedHLink.setParentLevel((Level)object);
            raggedHLink.setTargetMDObject((AbstractMDObject)object);
        }
        object = this.getProperties(element, "attributes_list");
        Object[] objectArray = object.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)object.get(objectArray[i]);
            Attribute attribute = (Attribute)raggedHLink.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string2);
            if (attribute == null) continue;
            raggedHLink.addChildToParentAttribute(attribute);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(raggedHLink.getObjectID())).append(".dmd");
        raggedHLink.setFilePath(stringBuffer.toString());
        return raggedHLink;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("raggedhlinkPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == RaggedHLink.class;
    }
}

