/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMultidimensionalDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static float NFS = 2.4f;
    private float loadedVersion = NFS;
    private static Logger LOGGER = new Logger(RXMLMultidimensionalDesign.class);

    public RXMLMultidimensionalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        int n;
        String string;
        Object[] objectArray;
        this.loadedVersion = designPart.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string2)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string2));
        }
        NodeList nodeList = RXMLMultidimensionalDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            objectArray = (Object[])nodeList.item(i);
            String string3 = objectArray.getAttribute("role");
            string = objectArray.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase(string3) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string);
            if (designObject != null) {
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                this.readGraphicalInfo((Element)objectArray, designObject);
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLMultidimensionalDesign: Read object returns null (objectID: " + string);
        }
        Map map = this.getProperties(element, "documents");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addDocument((BIDocument)designObject);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addResponsibleParty((BIResponsibleParty)designObject);
        }
        if (!this.xmlFromDB) {
            this.readLinks(element, (MultidimensionalDesign)designPart);
        }
        if (designPart.getDesign().getLoadedVersion() <= 2.1f) {
            ((MultidimensionalDesign)designPart).getCompactDiagram().generateDiagram();
        } else {
            this.readCompactDiagram(element, (MultidimensionalDesign)designPart);
        }
        this.readDisplayProperties(element, designPart.getMainView());
        designPart.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(element, designPart);
        designPart.getMainView().setDirty(false);
        ((MultidimensionalDesign)designPart).getCompactDiagram().setDirty(false);
        designPart.setLoaded(true);
        return designPart;
    }

    @Override
    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = RXMLMultidimensionalDesign.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
            }
        }
        return treeMap;
    }

    private void readLinks(Element element, MultidimensionalDesign multidimensionalDesign) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLMultidimensionalDesign.ReadLinks"));
        DesignPartView designPartView = multidimensionalDesign.getMainView();
        if (multidimensionalDesign.getAppView() != null && (element2 = RXMLMultidimensionalDesign.getFirstChildByTagName(element, "view_links")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                Object object;
                String string;
                boolean bl;
                String string2;
                Element element3;
                HashMap<String, String> hashMap;
                Object object2;
                Element element4;
                TVConnector tVConnector;
                int n3;
                Object object3;
                Object object4;
                String string3;
                String string4;
                AbstractMDObject abstractMDObject;
                Element element5 = (Element)nodeList.item(i);
                String string5 = element5.getAttribute("oid");
                String string6 = element5.getAttribute("type");
                if (string6.equalsIgnoreCase("Link")) {
                    abstractMDObject = (Link)multidimensionalDesign.getLinkSet().getObjectByID(string5);
                    string4 = element5.getAttribute("viewid_source");
                    string3 = element5.getAttribute("viewid_target");
                    if (!string4.equals("null") && ((ArrayList)(object4 = ((Link)abstractMDObject).getSourceMDObject().getViewsForDPV(designPartView))).size() == 1) {
                        object3 = (TopView)((ArrayList)object4).get(0);
                        ((Link)abstractMDObject).setSourceTV((AbstractMDTV)object3);
                    }
                    if (!string3.equals("null") && ((ArrayList)(object4 = ((Link)abstractMDObject).getTargetMDObject().getViewsForDPV(designPartView))).size() == 1) {
                        object3 = (TopView)((ArrayList)object4).get(0);
                        ((Link)abstractMDObject).setTargetTV((AbstractMDTV)object3);
                    }
                    object4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "points");
                    object3 = object4.getElementsByTagName("point");
                    n3 = object3.getLength();
                    tVConnector = (TVLink)((Link)abstractMDObject).getTopView();
                    for (int j = 0; j < n3; ++j) {
                        element4 = (Element)object3.item(j);
                        object2 = element4.getAttribute("x_coordinate");
                        hashMap = element4.getAttribute("y_coordinate");
                        tVConnector.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object2), Double.parseDouble((String)((Object)hashMap))));
                    }
                    element3 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "labels");
                    if (element3 != null && (element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element3, "main_label")) != null) {
                        object2 = element4.getAttribute("x_coordinate");
                        hashMap = element4.getAttribute("y_coordinate");
                        String string7 = element4.getAttribute("width");
                        string2 = element4.getAttribute("height");
                        if (object2 != null && !"".equals(object2)) {
                            if (string7 == null || "".equalsIgnoreCase(string7)) {
                                string7 = "-1";
                            }
                            if (string2 == null || "".equalsIgnoreCase(string2)) {
                                string2 = "-1";
                            }
                            tVConnector.setLabelBounds(new Rectangle((int)Double.parseDouble((String)object2), (int)Double.parseDouble(hashMap), (int)Double.parseDouble(string7), (int)Double.parseDouble(string2)));
                        }
                    }
                    if ((element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "graphical")) == null) continue;
                    object2 = element4.getElementsByTagName("parameter");
                    hashMap = new HashMap();
                    int n4 = object2.getLength();
                    for (int j = 0; j < n4; ++j) {
                        Element element6 = (Element)object2.item(j);
                        hashMap.put(element6.getAttribute("name"), element6.getAttribute("value"));
                    }
                    string2 = (String)hashMap.get("use_default_color");
                    bl = true;
                    if (string2 != null) {
                        bl = Boolean.valueOf(string2);
                    }
                    tVConnector.setUseDefaultColor(bl);
                    if (bl) continue;
                    string = (String)hashMap.get("color");
                    if (string != null && !"null".equalsIgnoreCase(string)) {
                        object = new Color(Integer.parseInt(string));
                        tVConnector.setBackgroundColor((Color)object);
                    }
                    if ((object = (String)hashMap.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                    n2 = Integer.parseInt((String)object);
                    tVConnector.setLineWidth(n2);
                    continue;
                }
                if (!string6.equalsIgnoreCase("RaggedHLink")) continue;
                abstractMDObject = (RaggedHLink)multidimensionalDesign.getRaggedHLinkSet().getObjectByID(string5);
                string4 = element5.getAttribute("viewid_source");
                string3 = element5.getAttribute("viewid_target");
                if (!string4.equals("null") && ((ArrayList)(object4 = ((RaggedHLink)abstractMDObject).getSourceMDObject().getViewsForDPV(designPartView))).size() == 1) {
                    object3 = (TopView)((ArrayList)object4).get(0);
                    ((RaggedHLink)abstractMDObject).setSourceTV((AbstractMDTV)object3);
                }
                if (!string3.equals("null") && ((ArrayList)(object4 = ((RaggedHLink)abstractMDObject).getTargetMDObject().getViewsForDPV(designPartView))).size() == 1) {
                    object3 = (TopView)((ArrayList)object4).get(0);
                    ((RaggedHLink)abstractMDObject).setTargetTV((AbstractMDTV)object3);
                }
                object4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "points");
                object3 = object4.getElementsByTagName("point");
                n3 = object3.getLength();
                tVConnector = (TVRaggedHLink)((RaggedHLink)abstractMDObject).getTopView();
                for (int j = 0; j < n3; ++j) {
                    element4 = (Element)object3.item(j);
                    object2 = element4.getAttribute("x_coordinate");
                    hashMap = element4.getAttribute("y_coordinate");
                    tVConnector.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object2), Double.parseDouble((String)((Object)hashMap))));
                }
                element3 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "labels");
                if (element3 == null || (element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element3, "main_label")) != null) {
                    // empty if block
                }
                if ((element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element5, "graphical")) == null) continue;
                object2 = element4.getElementsByTagName("parameter");
                hashMap = new HashMap<String, String>();
                int n5 = object2.getLength();
                for (int j = 0; j < n5; ++j) {
                    Element element7 = (Element)object2.item(j);
                    hashMap.put(element7.getAttribute("name"), element7.getAttribute("value"));
                }
                string2 = (String)hashMap.get("use_default_color");
                bl = true;
                if (string2 != null) {
                    bl = Boolean.valueOf(string2);
                }
                tVConnector.setUseDefaultColor(bl);
                if (bl) continue;
                string = (String)hashMap.get("color");
                if (string != null && !"null".equalsIgnoreCase(string)) {
                    object = new Color(Integer.parseInt(string));
                    tVConnector.setBackgroundColor((Color)object);
                }
                if ((object = (String)hashMap.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                n2 = Integer.parseInt((String)object);
                tVConnector.setLineWidth(n2);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("multidimensional");
            return stringBuffer.toString();
        }
        return "multidimensional";
    }

    private void readCompactDiagram(Element element, MultidimensionalDesign multidimensionalDesign) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLMultidimensionalDesign.ReadMultidimensionalCompactDiagram"));
        if (multidimensionalDesign.getAppView() != null && (element2 = RXMLMultidimensionalDesign.getFirstChildByTagName(element, "compact_diagram")) != null) {
            Object object;
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("id");
            String string3 = element2.getAttribute("generator");
            DPVCompactMultidimentional dPVCompactMultidimentional = multidimensionalDesign.getCompactDiagram();
            this.readDisplayProperties(element2, dPVCompactMultidimentional);
            dPVCompactMultidimentional.setName(string);
            ((DesignPartView)dPVCompactMultidimentional).setVisible(false);
            if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                dPVCompactMultidimentional.setDPVId(string2);
            }
            if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                dPVCompactMultidimentional.setGeneratorId(string3);
            }
            String string4 = element2.getAttribute("visible");
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3;
                String string5;
                String string6;
                Element element4;
                TVConnector tVConnector;
                int n2;
                NodeList nodeList2;
                Object object2;
                String string7;
                Object object3;
                DesignObject designObject;
                object = (Element)nodeList.item(i);
                String string8 = object.getAttribute("type");
                String string9 = object.getAttribute("oid");
                if (string8.equalsIgnoreCase("Cube")) {
                    designObject = (Cube)multidimensionalDesign.getCubeSet().getObjectByID(string9);
                    object3 = (TVCube)((TVCube)((AbstractMDObject)designObject).getTopView()).createViewSynonim(dPVCompactMultidimentional);
                    string7 = object.getAttribute("viewid");
                    object2 = object.getAttribute("tv_generator_id");
                    ((TopView)object3).setViewID(string7);
                    if (object2 != null && !"".equalsIgnoreCase((String)object2) && !"null".equalsIgnoreCase((String)object2)) {
                        ((TopView)object3).setGeneratorID((String)object2);
                    }
                    this.readGraphicalInfo((Element)object, (TopView)object3);
                }
                if (string8.equalsIgnoreCase("Dimension")) {
                    designObject = (Dimension)multidimensionalDesign.getDimensionSet().getObjectByID(string9);
                    object3 = (TVDimension)((TVDimension)((AbstractMDObject)designObject).getTopView()).createViewSynonim(dPVCompactMultidimentional);
                    string7 = object.getAttribute("viewid");
                    object2 = object.getAttribute("tv_generator_id");
                    ((TopView)object3).setViewID(string7);
                    if (object2 != null && !"".equalsIgnoreCase((String)object2) && !"null".equalsIgnoreCase((String)object2)) {
                        ((TopView)object3).setGeneratorID((String)object2);
                    }
                    this.readGraphicalInfo((Element)object, (TopView)object3);
                }
                if (string8.equalsIgnoreCase("Level")) {
                    designObject = (Level)multidimensionalDesign.getLevelSet().getObjectByID(string9);
                    object3 = (TVLevel)((TVLevel)((AbstractMDObject)designObject).getTopView()).createViewSynonim(dPVCompactMultidimentional);
                    string7 = object.getAttribute("viewid");
                    object2 = object.getAttribute("tv_generator_id");
                    ((TopView)object3).setViewID(string7);
                    if (object2 != null && !"".equalsIgnoreCase((String)object2) && !"null".equalsIgnoreCase((String)object2)) {
                        ((TopView)object3).setGeneratorID((String)object2);
                    }
                    this.readGraphicalInfo((Element)object, (TopView)object3);
                }
                if (string8.equalsIgnoreCase("Note")) {
                    designObject = (Note)this.getPersistenceManager().read((Object)string9, multidimensionalDesign.getDesign(), true);
                    object3 = (TVNote)((TVNote)((MultiShapedDesignObject)designObject).getTopView()).createViewSynonim(dPVCompactMultidimentional);
                    ((MultiShapedDesignObject)designObject).removeTopView(((MultiShapedDesignObject)designObject).getTopView());
                    string7 = object.getAttribute("viewid");
                    ((TopView)object3).setViewID(string7);
                    this.readGraphicalInfo((Element)object, (TopView)object3);
                }
                if (string8.equalsIgnoreCase("Link") && (designObject = (Link)multidimensionalDesign.getLinkSet().getObjectByID(string9)) != null) {
                    object3 = object.getAttribute("viewid_source");
                    string7 = object.getAttribute("viewid_target");
                    if (!((String)object3).equals("null")) {
                        ((Link)designObject).setSourceTV((AbstractMDTV)((Link)designObject).getSourceMDObject().getTopViewByID(dPVCompactMultidimentional, (String)object3));
                    }
                    if (!string7.equals("null")) {
                        ((Link)designObject).setTargetTV((AbstractMDTV)((Link)designObject).getTargetMDObject().getTopViewByID(dPVCompactMultidimentional, string7));
                    }
                    if ((object2 = RXMLMultidimensionalDesign.getFirstChildByTagName((Element)object, "points")) != null) {
                        nodeList2 = object2.getElementsByTagName("point");
                        n2 = nodeList2.getLength();
                        tVConnector = (TVLink)((Link)designObject).getViewFor(dPVCompactMultidimentional);
                        if (tVConnector != null) {
                            for (int j = 0; j < n2; ++j) {
                                element4 = (Element)nodeList2.item(j);
                                string6 = element4.getAttribute("x_coordinate");
                                string5 = element4.getAttribute("y_coordinate");
                                tVConnector.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string6), Double.parseDouble(string5)));
                            }
                            element3 = RXMLMultidimensionalDesign.getFirstChildByTagName((Element)object, "labels");
                            if (element3 != null && (element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element3, "main_label")) != null) {
                                string6 = element4.getAttribute("x_coordinate");
                                string5 = element4.getAttribute("y_coordinate");
                                String string10 = element4.getAttribute("width");
                                String string11 = element4.getAttribute("height");
                                if (string6 != null && !"".equals(string6)) {
                                    if (string10 == null || "".equalsIgnoreCase(string10)) {
                                        string10 = "-1";
                                    }
                                    if (string11 == null || "".equalsIgnoreCase(string11)) {
                                        string11 = "-1";
                                    }
                                    tVConnector.setLabelBounds(new Rectangle((int)Double.parseDouble(string6), (int)Double.parseDouble(string5), (int)Double.parseDouble(string10), (int)Double.parseDouble(string11)));
                                }
                            }
                        }
                    }
                }
                if (!string8.equalsIgnoreCase("RaggedHLink") || (designObject = (RaggedHLink)multidimensionalDesign.getRaggedHLinkSet().getObjectByID(string9)) == null) continue;
                object3 = object.getAttribute("viewid_source");
                string7 = object.getAttribute("viewid_target");
                if (!((String)object3).equals("null")) {
                    ((RaggedHLink)designObject).setSourceTV((AbstractMDTV)((RaggedHLink)designObject).getSourceMDObject().getTopViewByID(dPVCompactMultidimentional, (String)object3));
                }
                if (!string7.equals("null")) {
                    ((RaggedHLink)designObject).setTargetTV((AbstractMDTV)((RaggedHLink)designObject).getTargetMDObject().getTopViewByID(dPVCompactMultidimentional, string7));
                }
                if ((object2 = RXMLMultidimensionalDesign.getFirstChildByTagName((Element)object, "points")) == null) continue;
                nodeList2 = object2.getElementsByTagName("point");
                n2 = nodeList2.getLength();
                tVConnector = (TVRaggedHLink)((RaggedHLink)designObject).getViewFor(dPVCompactMultidimentional);
                if (tVConnector == null) continue;
                for (int j = 0; j < n2; ++j) {
                    element4 = (Element)nodeList2.item(j);
                    string6 = element4.getAttribute("x_coordinate");
                    string5 = element4.getAttribute("y_coordinate");
                    tVConnector.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string6), Double.parseDouble(string5)));
                }
                element3 = RXMLMultidimensionalDesign.getFirstChildByTagName(element2, "labels");
                if (element3 != null && (element4 = RXMLMultidimensionalDesign.getFirstChildByTagName(element3, "main_label")) == null) continue;
            }
            dPVCompactMultidimentional.setMustBeVisible(string4.equalsIgnoreCase("true"));
            String string12 = element2.getAttribute("comment");
            ((DesignPartViewPlaceHolder)dPVCompactMultidimentional.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(string12));
            object = element2.getAttribute("notes");
            ((DesignPartViewPlaceHolder)dPVCompactMultidimentional.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue((String)object));
            dPVCompactMultidimentional.getWorkSpace().updateSettings();
        }
    }

    public void readGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }
}

