/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMeasureFolder
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLMeasureFolder(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getMeasureFolderSet().createMeasureFolder(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        MeasureFolder measureFolder = (MeasureFolder)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        measureFolder.setDescription((String)map.get("description"));
        String string = (String)map.get("parent_folder");
        MeasureFolder measureFolder2 = (MeasureFolder)measureFolder.getDesign().getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(string);
        if (measureFolder2 != null) {
            measureFolder2.addSubfolders(measureFolder);
        }
        Element element2 = RXMLMeasureFolder.getFirstChildByTagName(element, "measure_wrappers");
        this.appendObject(element2, measureFolder, "measure_wrapper");
        Element element3 = RXMLMeasureFolder.getFirstChildByTagName(element, "measures");
        this.appendObject(element3, measureFolder, "measure");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(measureFolder.getObjectID())).append(".dmd");
        measureFolder.setFilePath(stringBuffer.toString());
        return measureFolder;
    }

    private void appendObject(Element element, MeasureFolder measureFolder, String string) {
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(string);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("measure_id");
                String string3 = element2.getAttribute("mfelement_parent_id");
                Measure measure = (Measure)measureFolder.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID(string2);
                DesignObject designObject = measureFolder.getDesign().getDesignObject(string3);
                MeasureFolder.MFElement mFElement = null;
                if (designObject instanceof Slice) {
                    String string4 = element2.getAttribute("aggr_function_id");
                    Slice.MeasureWrapper measureWrapper = ((Slice)designObject).getMeasureWrapper(measure, string4);
                    if (measureWrapper != null) {
                        MeasureFolder measureFolder2 = measureFolder;
                        measureFolder2.getClass();
                        mFElement = measureFolder2.new MeasureFolder.MFElement(designObject, measureWrapper);
                    }
                } else if (measure != null) {
                    MeasureFolder measureFolder3 = measureFolder;
                    measureFolder3.getClass();
                    mFElement = measureFolder3.new MeasureFolder.MFElement(designObject, measure);
                }
                if (mFElement == null) continue;
                measureFolder.addMeasure(mFElement);
            }
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("measureFolderPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == MeasureFolder.class;
    }
}

