/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.DimensionSet;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMeasure
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLMeasure(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getMeasureSet().createMeasure(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        String string;
        String string2;
        Object object;
        String string3;
        Measure measure = (Measure)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        measure.setDescription((String)map.get("description"));
        measure.setFormula(Boolean.valueOf((String)map.get("isformula")));
        String string4 = (String)map.get("is_custom_formula");
        if (string4 != null && "true".equalsIgnoreCase(string4)) {
            measure.setFormula(true);
        }
        if ((string3 = (String)map.get("formula")) != null) {
            measure.setFormula(StringUtilities.decodeAttributeValue(string3));
        }
        measure.setAdditivity((String)map.get("additivity"));
        String string5 = (String)map.get("measure_fact");
        if (string5 != null && (object = (Attribute)design.getLogicalDesign().getAttributeSet().getObjectByID(string5)) != null) {
            measure.setMeasureFact((ContainedObject)object);
        }
        if ((object = (String)map.get("aw_formula_type")) != null && !"null".equalsIgnoreCase((String)object)) {
            measure.setOracleAWFormulaType((String)object);
        }
        if ((string2 = (String)map.get("act_as_fact_dimension")) != null && !"null".equalsIgnoreCase(string2)) {
            measure.setActAsFactDimension(Boolean.valueOf(string2));
        }
        if ((string = (String)map.get("where_clause")) != null) {
            measure.setWhereClause(string);
        }
        this.appendOLAPMeasureProperties(measure, map);
        Map map2 = this.getProperties(element, "attributes_list");
        Object[] objectArray = map2.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string6 = (String)map2.get(objectArray[i]);
            Attribute attribute = (Attribute)measure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(string6);
            if (attribute == null) continue;
            measure.addAttribute(attribute);
        }
        this.handleAggrFunctions(element, measure);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(measure.getObjectID())).append(".dmd");
        measure.setFilePath(stringBuffer.toString());
        return measure;
    }

    private void appendOLAPMeasureProperties(Measure measure, Map map) {
        AbstractMDObject abstractMDObject;
        String string = (String)map.get("aw_operator");
        if (string != null) {
            measure.setOLAPOperator(string);
        }
        if ((string = (String)map.get("aw_offset")) != null) {
            measure.setOLAPOffset(Integer.valueOf(string));
        }
        if ((string = (String)map.get("aw_start")) != null) {
            measure.setOLAPStart(Integer.valueOf(string));
        }
        if ((string = (String)map.get("aw_step")) != null) {
            measure.setOLAPStep(Integer.valueOf(string));
        }
        if ((string = (String)map.get("aw_stop")) != null) {
            measure.setOLAPStop(Integer.valueOf(string));
        }
        if ((string = (String)map.get("aw_pd_operation")) != null) {
            measure.setOLAPPeriodToDateOperation(string);
        }
        if ((string = (String)map.get("aw_rank_direction")) != null) {
            measure.setRankDirectionCode(string);
        }
        string = (String)map.get("aw_measure");
        measure.setUsedOLAPMeasureID(string);
        string = (String)map.get("aw_dimension");
        if (string != null) {
            abstractMDObject = (Dimension)((MultidimensionalDesign)measure.getDesignPart()).getDimensionSet().getObjectByID(string);
            measure.setOLAPDimension((Dimension)abstractMDObject);
        }
        string = (String)map.get("aw_hierarchy");
        measure.setOlapHierarchyID(string);
        string = (String)map.get("aw_level");
        if (string != null) {
            abstractMDObject = (Level)((MultidimensionalDesign)measure.getDesignPart()).getLevelSet().getObjectByID(string);
            measure.setOLAPLevel((Level)abstractMDObject);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("measurePath"));
        return stringBuffer.toString();
    }

    private void handleAggrFunctions(Element element, Measure measure) {
        Element element2 = RXMLMeasure.getFirstChildByTagName(element, "aggregation_functions");
        DimensionSet dimensionSet = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getDimensionSet();
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("aggregation_function");
            int n = nodeList.getLength();
            List list = measure.getAggregateFunctions();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("function");
                String string2 = element3.getAttribute("id");
                Measure.AggregateFunction aggregateFunction = string2 != null && !"".equalsIgnoreCase(string2) ? measure.createAggregateFunction(string, string2) : measure.createAggregateFunction(string);
                aggregateFunction.measureAlias = element3.getAttribute("measure_alias");
                String string3 = element3.getAttribute("default");
                String string4 = element3.getAttribute("dimensions");
                String[] stringArray = string4.split(",");
                for (int j = 0; j < stringArray.length; ++j) {
                    Dimension dimension = (Dimension)dimensionSet.getObjectByID(stringArray[j]);
                    if (dimension == null) continue;
                    aggregateFunction.dimensions.add(dimension);
                }
                if ("true".equalsIgnoreCase(string3)) {
                    measure.setDefaultAggregationFunction(aggregateFunction);
                }
                this.handleSummaryLevels(element3, aggregateFunction, measure);
                list.add(aggregateFunction);
            }
        }
    }

    private void handleSummaryLevels(Element element, Measure.AggregateFunction aggregateFunction, Measure measure) {
        NodeList nodeList = element.getElementsByTagName("summary_level");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("level_id");
            Level level = (Level)((MultidimensionalDesign)measure.getDesignPart()).getLevelSet().getObjectByID(string);
            if (level == null) continue;
            aggregateFunction.levels.add(level);
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Measure.class;
    }
}

