/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLink
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLLink(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getLinkSet().createLink(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        Object object2;
        Link link = (Link)super.recreateObject(element, design, bl);
        NodeList nodeList = element.getElementsByTagName("connection");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Element)nodeList.item(i);
            object = object2.getAttribute("mdobject");
            AbstractMDObject abstractMDObject = (AbstractMDObject)design.getDesignObject((String)object);
            if ("source".equals(object2.getAttribute("endpoint"))) {
                link.setSourceMDObject(abstractMDObject);
                continue;
            }
            if (!"target".equals(object2.getAttribute("endpoint"))) continue;
            link.setTargetMDObject(abstractMDObject);
        }
        Map map = this.getProperties(element, "attributes");
        object2 = (String)map.get("rolluplink");
        if (!"null".equalsIgnoreCase((String)object2) && (object = (RollupLink)link.getDesign().getMultidimensionalDesign().getRollupLinkSet().getObjectByID((String)object2)) != null) {
            ((RollupLink)object).setParentLevel(link.getTargetMDObject());
            ((RollupLink)object).setChildLevel(link.getSource());
            link.setRollupLink((RollupLink)object);
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(link.getObjectID())).append(".dmd");
        link.setFilePath(((StringBuffer)object).toString());
        return link;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("linkPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Link.class;
    }
}

