/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLHierarchy
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLHierarchy(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getHierarchySet().createHierarchy(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        AbstractMDObject abstractMDObject;
        String string;
        int n;
        Hierarchy hierarchy = (Hierarchy)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        hierarchy.setDescription((String)map.get("description"));
        String string2 = (String)map.get("default_hierarchy");
        if (string2 != null) {
            hierarchy.setDefaultHierarchy(Boolean.valueOf(string2));
        }
        String string3 = (String)map.get("link_to_dimension");
        Link link = (Link)hierarchy.getDesign().getMultidimensionalDesign().getLinkSet().getObjectByID(string3);
        hierarchy.setLinkToDimension(link);
        if (link != null && link.getSourceMDObject() != null) {
            ((Dimension)link.getSourceMDObject()).addHierarchy(hierarchy);
        }
        Map map2 = this.getProperties(element, "levels");
        Object[] objectArray = map2.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map2.get(objectArray[n]);
            abstractMDObject = (Level)hierarchy.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID(string);
            if (abstractMDObject == null) continue;
            hierarchy.addLevel((Level)abstractMDObject);
        }
        map2 = this.getProperties(element, "links");
        objectArray = map2.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map2.get(objectArray[n]);
            abstractMDObject = (RollupLink)hierarchy.getDesign().getMultidimensionalDesign().getRollupLinkSet().getObjectByID(string);
            if (abstractMDObject == null) continue;
            hierarchy.addLink((RollupLink)abstractMDObject);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(hierarchy.getObjectID())).append(".dmd");
        hierarchy.setFilePath(stringBuffer.toString());
        return hierarchy;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("hierarchyPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Hierarchy.class;
    }
}

