/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDimension
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLDimension(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getDimensionSet().createDimension(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Dimension dimension = (Dimension)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        dimension.setDescription((String)map.get("description"));
        dimension.setTimeDimension(Boolean.valueOf((String)map.get("timedimension")));
        String string = (String)map.get("use_natural_keys");
        if (string != null && "FALSE".equalsIgnoreCase(string)) {
            dimension.setUseNaturalKeys(false);
        }
        this.handleCalcMembers(element, dimension);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(dimension.getObjectID())).append(".dmd");
        dimension.setFilePath(stringBuffer.toString());
        return dimension;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("dimensionPath"));
        return stringBuffer.toString();
    }

    private void handleCalcMembers(Element element, Dimension dimension) {
        Element element2 = RXMLDimension.getFirstChildByTagName(element, "calculated_members");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("calculated_member");
            int n = nodeList.getLength();
            List list = dimension.getPermanentCalcMembers();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("name");
                String string2 = element3.getAttribute("expression");
                if (string == null || string2 == null) continue;
                Dimension dimension2 = dimension;
                dimension2.getClass();
                Dimension.PermanentCalcMember permanentCalcMember = dimension2.new Dimension.PermanentCalcMember(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
                list.add(permanentCalcMember);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Dimension.class;
    }
}

