/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLCube
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLCube(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getCubeSet().createCube(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string;
        String string2;
        Cube cube = (Cube)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        cube.setDescription((String)map.get("description"));
        cube.setVirtual(Boolean.valueOf((String)map.get("virtual")));
        cube.setPartitioned(Boolean.valueOf((String)map.get("partitioned")));
        cube.setPartitioningDescription((String)map.get("partdescription"));
        String string3 = (String)map.get("global_composites");
        if (string3 != null && "true".equalsIgnoreCase(string3)) {
            cube.setUseGlobalComposites(true);
        }
        if ((string2 = (String)map.get("compressed_composites")) != null && "true".equalsIgnoreCase(string2)) {
            cube.setCompressedComposites(true);
        }
        if (!"null".equalsIgnoreCase(string = (String)map.get("fullcubemat")) && (object7 = (Slice)cube.getDesign().getMultidimensionalDesign().getSliceSet().getObjectByID(string)) != null) {
            cube.setFullCubeMaterialization((Slice)object7);
            ((Slice)object7).setCube(cube);
        }
        if ((object7 = (String)map.get("part_dimension")) != null && !"null".equalsIgnoreCase((String)object7) && (object6 = (Dimension)cube.getDesign().getMultidimensionalDesign().getDimensionSet().getObjectByID((String)object7)) != null) {
            cube.setPartDimension((Dimension)object6);
        }
        if ((object6 = (String)map.get("part_level")) != null && !"null".equalsIgnoreCase((String)object6) && (object5 = (Level)cube.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID((String)object6)) != null) {
            cube.setPartLevel((Level)object5);
        }
        if ((object5 = (String)map.get("part_hierarchy")) != null && !"null".equalsIgnoreCase((String)object5)) {
            cube.setPartHierarchyID((String)object5);
        }
        map = this.getProperties(element, "dimensions");
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string4 = (String)map.get(objectArray[i]);
            object4 = (Dimension)cube.getDesign().getMultidimensionalDesign().getDimensionSet().getObjectByID(string4);
            if (object4 == null) continue;
            cube.getDimensionsOrderList().add(object4);
        }
        map = this.getProperties(element, "measures");
        Object[] objectArray2 = map.keySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            object4 = (String)map.get(objectArray2[i]);
            object3 = (Measure)cube.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID((String)object4);
            if (object3 == null) continue;
            cube.addMeasure((Measure)object3);
        }
        map = this.getProperties(element, "slices");
        Object[] objectArray3 = map.keySet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            object3 = (String)map.get(objectArray3[i]);
            object2 = (Slice)cube.getDesign().getMultidimensionalDesign().getSliceSet().getObjectByID((String)object3);
            if (object2 == null) continue;
            cube.addPrecalculatedSlice((Slice)object2);
        }
        map = this.getProperties(element, "fact_entities");
        Object[] objectArray4 = map.keySet().toArray();
        for (int i = 0; i < objectArray4.length; ++i) {
            object2 = (String)map.get(objectArray4[i]);
            object = (ContainerObject)cube.getDesign().getLogicalDesign().getEntitySet().getObjectByID((String)object2);
            if (object == null) {
                object = (ContainerObject)cube.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID((String)object2);
            }
            if (object == null) continue;
            cube.addFactEntity((ContainerObject)object);
        }
        map = this.getProperties(element, "fact_joins");
        Object[] objectArray5 = map.keySet().toArray();
        for (int i = 0; i < objectArray5.length; ++i) {
            object = (String)map.get(objectArray5[i]);
            FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)cube.getDesign().getMultidimensionalDesign().getFactEntitiesJoinSet().getObjectByID((String)object);
            if (factEntitiesJoin == null) continue;
            cube.addFactEntitiesJoin(factEntitiesJoin);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(cube.getObjectID())).append(".dmd");
        cube.setFilePath(stringBuffer.toString());
        return cube;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("cubePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Cube.class;
    }
}

