/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.mapping;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLExtendedMap
extends AbstractXMLWriter {
    private ExtendedMap extendedMap = null;

    public WXMLExtendedMap(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof ExtendedMap || object instanceof XtdMapping;
    }

    @Override
    public Document writeDocument(Object object) {
        Document document = null;
        if (object instanceof ExtendedMap) {
            this.extendedMap = (ExtendedMap)object;
            Design design = this.extendedMap.getDesign();
            document = this.createDocument("extendedmap");
            Element element = document.getDocumentElement();
            Element element2 = document.createElement("mappings");
            element.appendChild(element2);
            Object[] objectArray = this.extendedMap.getMappings().keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                XtdMapping xtdMapping = (XtdMapping)this.extendedMap.getMappings().get(objectArray[i]);
                DesignObject designObject = xtdMapping.getOwnerObject();
                DesignObject designObject2 = xtdMapping.getTargetObject();
                if (designObject != null && designObject2 != null) {
                    if (!design.shouldExportMappedObject(designObject2) || !design.shouldExportMappedObject(designObject)) continue;
                    this.appendMapping(element2, xtdMapping);
                    continue;
                }
                this.appendMapping(element2, xtdMapping);
            }
            for (XtdMapping xtdMapping : this.extendedMap.getDeletedMappings()) {
                this.appendMapping(element2, xtdMapping);
            }
        } else {
            XtdMapping xtdMapping = (XtdMapping)object;
            document = this.createDocument("extmapping");
            Element element = document.getDocumentElement();
            this.appendMappingProperties(element, xtdMapping);
        }
        return document;
    }

    private void appendMapping(Element element, XtdMapping xtdMapping) {
        Map map = this.createPropertesMap(xtdMapping);
        Element element2 = element.getOwnerDocument().createElement("extmapping");
        element.appendChild(element2);
        this.appendProperties(map, element2);
        this.appendCollections(element2, xtdMapping);
    }

    private void appendMappingProperties(Element element, XtdMapping xtdMapping) {
        Map map = this.createPropertesMap(xtdMapping);
        this.appendProperties(map, element);
        this.appendCollections(element, xtdMapping);
    }

    private void appendCollections(Element element, XtdMapping xtdMapping) {
        this.appendContained(element, "attributes", xtdMapping.getAttributes());
        this.appendContained(element, "columns", xtdMapping.getColumns());
        this.appendContained(element, "keys", xtdMapping.getKeys());
        this.appendContained(element, "indexes", xtdMapping.getIndexes());
    }

    private Map createPropertesMap(XtdMapping xtdMapping) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("owner.id", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerID()));
        treeMap.put("owner.type", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.getOwnerType())));
        treeMap.put("owner.name", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerName()));
        treeMap.put("owner.design.id", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerDesignPartID()));
        treeMap.put("owner.design.name", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerDesignPartName()));
        treeMap.put("target.id", StringUtilities.encodeAttributeValue(xtdMapping.getTargetID()));
        treeMap.put("target.type", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.getTargetType())));
        treeMap.put("target.name", StringUtilities.encodeAttributeValue(xtdMapping.getTargetName()));
        treeMap.put("target.design.id", StringUtilities.encodeAttributeValue(xtdMapping.getTargetDesignPartID()));
        treeMap.put("target.design.name", StringUtilities.encodeAttributeValue(xtdMapping.getRealSourceEntityID()));
        if (xtdMapping.getOwnerRepOID() != null) {
            treeMap.put("owner.repoid", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerRepOID()));
        }
        if (xtdMapping.getTargetRepOID() != null) {
            treeMap.put("target.repoid", StringUtilities.encodeAttributeValue(xtdMapping.getTargetRepOID()));
        }
        if (xtdMapping.getRepositoryOID() != null) {
            treeMap.put("rep_oid", StringUtilities.encodeAttributeValue(xtdMapping.getRepositoryOID()));
        }
        if (xtdMapping.getRepositoryOVID() != null) {
            treeMap.put("rep_ovid", StringUtilities.encodeAttributeValue(xtdMapping.getRepositoryOVID()));
        }
        if (xtdMapping.getRealSourceEntityID() != null) {
            treeMap.put("real_source_entity_id", StringUtilities.encodeAttributeValue(xtdMapping.getRealSourceEntityID()));
        }
        if (xtdMapping.getRealTargetEntityID() != null) {
            treeMap.put("real_target_entity_id", xtdMapping.getRealTargetEntityID());
        }
        if (xtdMapping.getDeletedID() != null) {
            treeMap.put("deleted_id", xtdMapping.getDeletedID());
        }
        if (!"".equals(xtdMapping.getRecreatedContainerID())) {
            treeMap.put("recreated_container_id", xtdMapping.getRecreatedContainerID());
        }
        if (xtdMapping.getOwnerContainerID() != null) {
            treeMap.put("owner_container_id", StringUtilities.encodeAttributeValue(xtdMapping.getOwnerContainerID()));
        }
        if (xtdMapping.getTargetContainerID() != null) {
            treeMap.put("target_container_id", StringUtilities.encodeAttributeValue(xtdMapping.getTargetContainerID()));
        }
        treeMap.put("inheritance_type", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.getInheritanceType())));
        treeMap.put("fw_engineer", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.isFwEngineer())));
        treeMap.put("rev_engineer", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.isRevEngineer())));
        treeMap.put("creationTime", StringUtilities.encodeAttributeValue(String.valueOf(xtdMapping.getCreationTime())));
        return treeMap;
    }

    @Override
    public String getFilenameFor(Object object) {
        return "ExtendedMap";
    }

    @Override
    public String getRelativePath() {
        if (this.extendedMap != null && this.extendedMap.getDesign().getAppView() != null) {
            String string = this.extendedMap.getDesign().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("mapping");
            return stringBuffer.toString();
        }
        return "mapping";
    }

    private void appendProperties(Map map, Element element) {
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            String string2 = (String)map.get(string);
            if (string.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element2 = element.getOwnerDocument().createElement("parameter");
            element.appendChild(element2);
            this.appendProperty(element2, string, string2);
        }
    }

    private void appendContained(Element element, String string, List list) {
        if (list.size() > 0) {
            Element element2 = element.getOwnerDocument().createElement(string);
            for (String string2 : list) {
                Element element3 = element.getOwnerDocument().createElement("cont_id");
                element3.setAttribute("value", string2);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }
}

