/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.mapping;

import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLExtendedMap
extends AbstractXMLReader {
    private static Logger LOGGER = new Logger(RXMLExtendedMap.class);

    public RXMLExtendedMap(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        if (design != null) {
            try {
                Element element = document.getDocumentElement();
                XtdMapping xtdMapping = this.parseMapping(element, design);
                return xtdMapping;
            }
            catch (Exception exception) {
                Design.openFailed();
                LOGGER.error("RXMLExtendedMap.recreateObject()", exception);
            }
        }
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        Design design = this.getDesign();
        if (design != null) {
            try {
                Element element = document.getDocumentElement();
                NodeList nodeList = RXMLExtendedMap.getFirstChildByTagName(element, "mappings").getElementsByTagName("extmapping");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    this.parseMapping(element2, design);
                }
            }
            catch (Exception exception) {
                Design.openFailed();
                LOGGER.error("RXMLExtendedMap.recreateDesign()", exception);
            }
        } else {
            LOGGER.error("RXMLExtendedMap.recreateDesign(): Unable to get Design!");
        }
        return designPart;
    }

    private XtdMapping parseMapping(Element element, Design design) {
        Object object;
        XtdMapping xtdMapping = null;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object = (Element)nodeList.item(i);
            treeMap.put(object.getAttribute("name"), object.getAttribute("value"));
        }
        String string = (String)treeMap.get("deleted_id");
        object = null;
        if (string != null && !"".equals(string)) {
            object = design.getDesignObject(string);
        }
        if (object == null) {
            String string2;
            String string3;
            String string4;
            String string5;
            Object object2;
            String string6 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner.id"));
            String string7 = StringUtilities.decodeAttributeValue((String)treeMap.get("target.id"));
            long l = Long.parseLong((String)treeMap.get("creationTime"));
            String string8 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner.type"));
            int n2 = -1;
            if (string8 != null && !"".equals(string8)) {
                try {
                    n2 = Integer.parseInt(string8);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            DesignObject designObject = null;
            DesignObject designObject2 = null;
            if (10 == n2) {
                object2 = design.getDesignPartView(string6);
                if (object2 != null) {
                    designObject = ((DesignPartView)object2).getPlaceHolder();
                    object2 = design.getDesignPartView(string7);
                    if (object2 != null) {
                        designObject2 = ((DesignPartView)object2).getPlaceHolder();
                    }
                }
            } else {
                designObject = design.getDesignObject(string6);
                designObject2 = design.getDesignObject(string7);
            }
            object2 = StringUtilities.decodeAttributeValue((String)treeMap.get("recreated_container_id"));
            if (designObject != null && designObject2 != null && string == null) {
                xtdMapping = design.getExtendedMap().createMapping(designObject, designObject2);
                string5 = StringUtilities.decodeAttributeValue((String)treeMap.get("inheritance_type"));
                if (string5 == null) {
                    xtdMapping.setInheritanceType(-1);
                } else {
                    xtdMapping.setInheritanceType(Integer.valueOf(string5));
                }
                string4 = StringUtilities.decodeAttributeValue((String)treeMap.get("real_source_entity_id"));
                if (string4 != null) {
                    xtdMapping.setRealSourceEntityID(string4);
                }
                if ((string3 = StringUtilities.decodeAttributeValue((String)treeMap.get("real_target_entity_id"))) != null) {
                    xtdMapping.setRealTargetEntityID(string3);
                }
                if (object2 != null) {
                    xtdMapping.setRecreatedContainerID((String)object2);
                }
                string2 = (String)treeMap.get("rep_oid");
                String string9 = (String)treeMap.get("rep_ovid");
                if (string2 != null) {
                    xtdMapping.setRepositoryOID(string2);
                }
                if (string9 != null) {
                    xtdMapping.setRepositoryOVID(string9);
                }
                xtdMapping.setCreationTime(l);
            } else {
                String string10;
                int n3 = Integer.parseInt((String)treeMap.get("owner.type"));
                string4 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner.name"));
                string3 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner.design.id"));
                string2 = (String)treeMap.get("owner.design.name");
                int n4 = Integer.parseInt((String)treeMap.get("target.type"));
                String string11 = StringUtilities.decodeAttributeValue((String)treeMap.get("target.name"));
                String string12 = StringUtilities.decodeAttributeValue((String)treeMap.get("target.design.id"));
                String string13 = StringUtilities.decodeAttributeValue((String)treeMap.get("target.design.name"));
                xtdMapping = string != null ? design.getExtendedMap().createMapping(string6, string7, string) : design.getExtendedMap().createMapping(string6, string7);
                xtdMapping.setDesign(design);
                xtdMapping.setCreationTime(l);
                xtdMapping.setOwnerType(n3);
                xtdMapping.setOwnerName(string4);
                xtdMapping.setOwnerDesignPartID(string3);
                xtdMapping.setOwnerDesignPartName(string2);
                xtdMapping.setTargetType(n4);
                xtdMapping.setTargetName(string11);
                xtdMapping.setTargetDesignPartID(string12);
                xtdMapping.setTargetDesignPartName(string13);
                String string14 = StringUtilities.decodeAttributeValue((String)treeMap.get("inheritance_type"));
                String string15 = StringUtilities.decodeAttributeValue((String)treeMap.get("real_source_entity_id"));
                String string16 = StringUtilities.decodeAttributeValue((String)treeMap.get("rep_oid"));
                String string17 = StringUtilities.decodeAttributeValue((String)treeMap.get("rep_ovid"));
                String string18 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner.repoid"));
                String string19 = StringUtilities.decodeAttributeValue((String)treeMap.get("target.repoid"));
                if (string15 != null) {
                    xtdMapping.setRealSourceEntityID(string15);
                }
                if ((string10 = StringUtilities.decodeAttributeValue((String)treeMap.get("real_target_entity_id"))) != null) {
                    xtdMapping.setRealTargetEntityID(string10);
                }
                if (object2 != null) {
                    xtdMapping.setRecreatedContainerID((String)object2);
                }
                if (string14 == null) {
                    xtdMapping.setInheritanceType(-1);
                } else {
                    xtdMapping.setInheritanceType(Integer.valueOf(string14));
                }
                if (string16 != null) {
                    xtdMapping.setRepositoryOID(string16);
                }
                if (string17 != null) {
                    xtdMapping.setRepositoryOVID(string17);
                }
                if (string18 != null) {
                    xtdMapping.setOwnerRepOID(string18);
                }
                if (string19 != null) {
                    xtdMapping.setTargetRepOID(string19);
                }
            }
            if (xtdMapping != null) {
                string5 = StringUtilities.decodeAttributeValue((String)treeMap.get("owner_container_id"));
                string4 = StringUtilities.decodeAttributeValue((String)treeMap.get("target_container_id"));
                if (string5 != null && !"".equals(string5)) {
                    xtdMapping.setOwnerContainerID(string5);
                }
                if (string4 != null && !"".equals(string4)) {
                    xtdMapping.setTargetContainerID(string4);
                }
                string3 = StringUtilities.decodeAttributeValue((String)treeMap.get("fw_engineer"));
                string2 = StringUtilities.decodeAttributeValue((String)treeMap.get("rev_engineer"));
                if (string3 != null && !"true".equalsIgnoreCase(string3)) {
                    xtdMapping.setFwEngineer(false);
                }
                if (string2 != null && !"true".equalsIgnoreCase(string2)) {
                    xtdMapping.setFwEngineer(false);
                }
                if (design.getLoadedVersion() > 2.2f && (xtdMapping.getOwnerType() == 0 || xtdMapping.getTargetType() == 0)) {
                    this.readContainedMappings(element, xtdMapping, "attributes", xtdMapping.getAttributes());
                    this.readContainedMappings(element, xtdMapping, "columns", xtdMapping.getColumns());
                    this.readContainedMappings(element, xtdMapping, "keys", xtdMapping.getKeys());
                    this.readContainedMappings(element, xtdMapping, "indexes", xtdMapping.getIndexes());
                }
                xtdMapping.setDirty(false);
            }
        }
        return xtdMapping;
    }

    public Design getDesign() {
        if (this.getPersistenceManager().getAppView() != null) {
            return this.getPersistenceManager().getAppView().getCurrentDesign();
        }
        return null;
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("mapping");
            return stringBuffer.toString();
        }
        return "mapping";
    }

    private void readContainedMappings(Element element, XtdMapping xtdMapping, String string, List list) {
        Element element2 = RXMLExtendedMap.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("cont_id");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string2 = element3.getAttribute("value");
                list.add(string2);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == XtdMapping.class;
    }
}

