/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLStructuredType
extends AbstractWXMLDesignObject
implements DTConstants {
    private StructuredType structuredType = null;

    public WXMLStructuredType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof StructuredType;
        if (bl) {
            this.structuredType = (StructuredType)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.structuredType != null) {
            String string = this.structuredType.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("structuredtypePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)designObject;
            DesignPart designPart = designObject.getDesignPart();
            boolean bl = designObject.getFirstViewForDPV(designPart.getMainView()) != null && designObject.isVisible();
            element.setAttribute("visible", String.valueOf(bl));
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("parent_type", String.valueOf(structuredType.getParentType() != null ? StringUtilities.encodeAttributeValue(structuredType.getParentType().getObjectID()) : "null"));
            treeMap.put("final", String.valueOf(structuredType.isFinal()));
            treeMap.put("instantiable", String.valueOf(structuredType.isInstantiable()));
            treeMap.put("predefined", String.valueOf(structuredType.isPredefined()));
            this.appendProperties(element, "attributes", treeMap);
        }
    }

    @Override
    protected void appendContainedElements(Document document, Element element, DesignObject designObject) {
        Element element2 = document.createElement("contained");
        element.appendChild(element2);
        TypeElement[] typeElementArray = ((StructuredType)designObject).getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            this.appendElementInfo(document, element2, typeElementArray[i]);
        }
        element2 = document.createElement("methods");
        element.appendChild(element2);
        Method[] methodArray = ((StructuredType)designObject).getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.appendMethodInfo(document, element2, methodArray[i]);
        }
    }

    private Element appendElementInfo(Document document, Element element, TypeElement typeElement) {
        Element element2 = this.appendDesignObjectInfo(document, element, typeElement);
        element.appendChild(element2);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("reference", String.valueOf(typeElement.isReference()));
        treeMap.put("typeid", typeElement.getType() != null ? StringUtilities.encodeAttributeValue(typeElement.getType().getObjectID()) : "null");
        treeMap.put("size", String.valueOf(typeElement.getSize()));
        treeMap.put("Scale", String.valueOf(typeElement.getScale()));
        treeMap.put("Precision", String.valueOf(typeElement.getPrecision()));
        treeMap.put("mandatory", String.valueOf(typeElement.isMandatory()));
        this.appendProperties(element2, "attributes", treeMap);
        return element2;
    }

    private Element appendMethodInfo(Document document, Element element, Method method) {
        Element element2 = this.appendDesignObjectInfo(document, element, method);
        element.appendChild(element2);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("constructor", String.valueOf(method.isConstructor()));
        treeMap.put("overrided_method", method.getOverridedMethod() != null ? StringUtilities.encodeAttributeValue(method.getOverridedMethod().getObjectID()) : "null");
        treeMap.put("body", method.getBody());
        this.appendProperties(element2, "attributes", treeMap);
        treeMap = new TreeMap();
        for (MethodParam methodParam : method.getParameters()) {
            this.appendParamInfo(document, element2, methodParam, "methodparam");
        }
        if (method.getReturnValue() != null) {
            this.appendParamInfo(document, element2, method.getReturnValue(), "return_value");
        }
        return element2;
    }

    private Element appendParamInfo(Document document, Element element, MethodParam methodParam, String string) {
        Element element2 = document.createElement(string);
        element.appendChild(element2);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("id", methodParam.getObjectID());
        treeMap.put("name", methodParam.getName());
        treeMap.put("typeid", methodParam.getType() != null ? StringUtilities.encodeAttributeValue(methodParam.getType().getObjectID()) : "null");
        treeMap.put("size", String.valueOf(methodParam.getSize()));
        treeMap.put("Scale", String.valueOf(methodParam.getScale()));
        treeMap.put("Precision", String.valueOf(methodParam.getPrecision()));
        treeMap.put("reference", String.valueOf(methodParam.isReference()));
        this.appendProperties(element2, "attributes", treeMap);
        return element2;
    }
}

