/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLDataTypesDesign
extends AbstractXMLWriter {
    private DataTypesDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLDataTypesDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DataTypesDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (DataTypesDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element element2 = document.createElement("ref");
            element.appendChild(element2);
            Element element3 = null;
            Element element4 = null;
            if (this.version < NFS) {
                element3 = document.createElement("view_relations");
                element.appendChild(element3);
                element4 = document.createElement("datatype_sub_views_collection");
                element.appendChild(element4);
            }
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                this.handleDesignObject(element2, designObject);
            }
            if (this.version < NFS) {
                this.handleRelations(this.design, element3);
                this.appendSubordinateDisplays(element, this.design.getMainView());
                this.handleDTSubView(this.design, element4);
                this.appendDiagramViews(document, element, this.design);
            } else {
                WXMLSubview wXMLSubview = this.getPersistenceManager().getDesignPartViewWriter();
                wXMLSubview.appendExtSubViews(element, this.design);
            }
            this.appendDocumentsInfo(document, element, this.design);
            this.appendPartiesInfo(document, element, this.design);
            this.design.setDirty(false);
            return document;
        }
        return null;
    }

    private void appendDocumentsInfo(Document document, Element element, DataTypesDesign dataTypesDesign) {
        this.appendObjects(element, dataTypesDesign.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, DataTypesDesign dataTypesDesign) {
        this.appendObjects(element, dataTypesDesign.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        }
        this.appendProperties(element, string, treeMap);
    }

    @Override
    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (this.version < NFS && (designObject instanceof StructuredType || designObject instanceof Note)) {
            this.appendGraphicalInfo(element2, designObject);
        }
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    public void handleRelations(DataTypesDesign dataTypesDesign, Element element) {
        if (dataTypesDesign.getAppView() != null) {
            DTRelation dTRelation;
            Iterator iterator = dataTypesDesign.getDTInheritanceSet().iterator();
            while (iterator.hasNext()) {
                dTRelation = (DTInheritance)iterator.next();
                this.appendRelationObjectElement(dataTypesDesign, element, dTRelation);
            }
            iterator = dataTypesDesign.getDTReferenceSet().iterator();
            while (iterator.hasNext()) {
                dTRelation = (DTReference)iterator.next();
                this.appendRelationObjectElement(dataTypesDesign, element, dTRelation);
            }
        }
    }

    private void appendRelationObjectElement(DataTypesDesign dataTypesDesign, Element element, DTRelation dTRelation) {
        Object object;
        EdgeView edgeView;
        AbstractDTObject abstractDTObject;
        Document document = element.getOwnerDocument();
        TVDTRelation tVDTRelation = (TVDTRelation)dTRelation.getTopView();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(dTRelation.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(dTRelation.getObjectID()));
        if (dTRelation instanceof DTReference) {
            element2.setAttribute("stelement", StringUtilities.encodeAttributeValue(((DTReference)dTRelation).getTypeElement().getObjectID()));
        }
        element2.setAttribute("viewid_source", (abstractDTObject = dTRelation.getSourceDTObject()) != null ? StringUtilities.encodeAttributeValue(abstractDTObject.getObjectID()) : "null");
        element2.setAttribute("viewid_target", abstractDTObject != null ? StringUtilities.encodeAttributeValue(abstractDTObject.getObjectID()) : "null");
        Element element3 = document.createElement("points");
        if (tVDTRelation != null && tVDTRelation.getCellView() != null) {
            edgeView = (EdgeView)((DefaultEdge)tVDTRelation.getCellView().getCell()).getCellView();
            object = edgeView.getPoints();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (point2D == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (tVDTRelation != null) {
            edgeView = (EdgeView)tVDTRelation.getCellView();
            if (edgeView != null) {
                object = document.createElement("labels");
                Element element5 = document.createElement("main_label");
                object.appendChild(element5);
                element2.appendChild((Node)object);
            }
            object = document.createElement("graphical");
            Element element6 = element2.getOwnerDocument().createElement("parameter");
            object.appendChild(element6);
            element6.setAttribute("name", "use_default_color");
            element6.setAttribute("value", Boolean.toString(tVDTRelation.useDefaultColor()));
            if (!tVDTRelation.useDefaultColor()) {
                element6 = element2.getOwnerDocument().createElement("parameter");
                object.appendChild(element6);
                element6.setAttribute("name", "color");
                element6.setAttribute("value", tVDTRelation.getBackgroundColor() != null ? Integer.toString(tVDTRelation.getBackgroundColor().getRGB()) : "null");
                element6 = element2.getOwnerDocument().createElement("parameter");
                object.appendChild(element6);
                element6.setAttribute("name", "width");
                element6.setAttribute("value", Integer.toString(tVDTRelation.getLineWidth()));
            }
            element2.appendChild((Node)object);
        }
        element.appendChild(element2);
    }

    @Override
    public String getFilenameFor(Object object) {
        DataTypesDesign dataTypesDesign = (DataTypesDesign)object;
        return dataTypesDesign.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("datatypes");
            return stringBuffer.toString();
        }
        return "datatypes";
    }

    public void handleDTSubView(DataTypesDesign dataTypesDesign, Element element) {
        if (dataTypesDesign.getAppView() != null) {
            Document document = element.getOwnerDocument();
            SubViewObjectSet subViewObjectSet = dataTypesDesign.getDataTypesDesignSubViews();
            Iterator iterator = subViewObjectSet.iterator();
            while (iterator.hasNext()) {
                DTRelation dTRelation;
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                DPVDataTypesSubView dPVDataTypesSubView = (DPVDataTypesSubView)designPartViewPlaceHolder.getDesignPartView();
                Element element2 = document.createElement("datatype_sub_view");
                element2.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dPVDataTypesSubView.getName()));
                element2.setAttribute("id", dPVDataTypesSubView.getDPVId());
                element2.setAttribute("generator", dPVDataTypesSubView.getGeneratorId());
                element2.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
                element2.setAttribute("comment", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getComment()));
                element2.setAttribute("notes", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getNotes()));
                element.appendChild(element2);
                this.addStructuredTypesInDPV(dataTypesDesign, element2, dPVDataTypesSubView);
                this.addNotesInDPV(dataTypesDesign, element2, dPVDataTypesSubView);
                Iterator iterator2 = dataTypesDesign.getDTReferenceSet().iterator();
                while (iterator2.hasNext()) {
                    dTRelation = (DTReference)iterator2.next();
                    this.appendSubViewInfoRelation(element2, dPVDataTypesSubView, dTRelation);
                }
                iterator2 = dataTypesDesign.getDTInheritanceSet().iterator();
                while (iterator2.hasNext()) {
                    dTRelation = (DTInheritance)iterator2.next();
                    this.appendSubViewInfoRelation(element2, dPVDataTypesSubView, dTRelation);
                }
                this.appendSubordinateDisplays(element2, dPVDataTypesSubView);
            }
        }
    }

    private void appendSubViewInfoRelation(Element element, DesignPartView designPartView, DTRelation dTRelation) {
        block7: {
            try {
                Document document = element.getOwnerDocument();
                TVDTRelation tVDTRelation = (TVDTRelation)dTRelation.getViewFor(designPartView);
                if (tVDTRelation == null || dTRelation.getSourceTV(designPartView) == null || dTRelation.getTargetTV(designPartView) == null) break block7;
                Element element2 = document.createElement("objectid");
                element2.setAttribute("role", "represents");
                element2.setAttribute("type", StringUtilities.encodeAttributeValue(dTRelation.getObjectTypeName()));
                element2.setAttribute("oid", StringUtilities.encodeAttributeValue(dTRelation.getObjectID()));
                element2.setAttribute("viewid_source", dTRelation.getSourceTV(designPartView) != null ? dTRelation.getSourceTV(designPartView).getViewID() : "null");
                element2.setAttribute("viewid_target", dTRelation.getTargetTV(designPartView) != null ? dTRelation.getTargetTV(designPartView).getViewID() : "null");
                Element element3 = document.createElement("points");
                if (tVDTRelation != null) {
                    if (tVDTRelation.getCellView() != null) {
                        List list = ((EdgeView)tVDTRelation.getCellView()).getPoints();
                        for (int i = 0; i < list.size(); ++i) {
                            Object e = list.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element4 = document.createElement("point");
                            element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element4);
                        }
                    } else {
                        List list = tVDTRelation.getEdgePoints();
                        for (int i = 0; i < list.size(); ++i) {
                            Object e = list.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element5 = document.createElement("point");
                            element5.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element5.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element5);
                        }
                    }
                }
                element2.appendChild(element3);
                element.appendChild(element2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addStructuredTypesInDPV(DataTypesDesign dataTypesDesign, Element element, DPVDataTypesSubView dPVDataTypesSubView) {
        Iterator iterator = dataTypesDesign.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            for (TopView topView : structuredType.getViewsForDPV(dPVDataTypesSubView)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addNotesInDPV(DataTypesDesign dataTypesDesign, Element element, DPVDataTypesSubView dPVDataTypesSubView) {
        Iterator iterator = dataTypesDesign.getNoteSet().iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            TopView topView = note.getFirstViewForDPV(dPVDataTypesSubView);
            if (topView == null) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }

    private void appendReferencedObjectReprElement(Element element, TopView topView) {
        Document document = element.getOwnerDocument();
        DesignObject designObject = topView.getModel();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("viewid", StringUtilities.encodeAttributeValue(topView.getViewID()));
        element2.setAttribute("tv_generator_id", StringUtilities.encodeAttributeValue(topView.getGeneratorID()));
        this.appendGraphicalInfo(element2, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }
}

