/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLCollectionType
extends AbstractWXMLDesignObject
implements DTConstants {
    private CollectionType collectionType = null;

    public WXMLCollectionType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof CollectionType;
        if (bl) {
            this.collectionType = (CollectionType)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.collectionType != null) {
            String string = this.collectionType.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("collectiontypePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("collection_type", String.valueOf(collectionType.getType() != null ? collectionType.getType() : "null"));
            treeMap.put("max_element", String.valueOf(collectionType.getMaxElement()));
            treeMap.put("datatype", StringUtilities.encodeAttributeValue(String.valueOf(collectionType.getElementType().getType().getObjectID())));
            treeMap.put("reference", String.valueOf(collectionType.getElementType().isReference()));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

