/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLDistinctType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLDistinctType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getDataTypesDesign().getDistinctTypeSet().createDistinctType(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        DistinctType distinctType = (DistinctType)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        String string = StringUtilities.decodeAttributeValue((String)map.get("LogicalType"));
        if (!"null".equalsIgnoreCase(string) && (object = (LogicalDatatype)distinctType.getDesign().getLogicalDatatypeSet().getObjectByID(string)) != null) {
            distinctType.setLogicalDataType((LogicalDatatype)object);
        }
        distinctType.setSize((String)map.get("size"));
        try {
            distinctType.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            distinctType.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(distinctType.getObjectID())).append(".dmd");
        distinctType.setFilePath(((StringBuffer)object).toString());
        return distinctType;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("distincttypePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == DistinctType.class;
    }
}

