/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLPhone
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIPhone phone = null;

    public WXMLPhone(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof BIPhone;
        if (bl) {
            this.phone = (BIPhone)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.phone != null) {
            String string = this.phone.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("phonePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof BIPhone) {
            BIPhone bIPhone = (BIPhone)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("number", StringUtilities.encodeAttributeValue(String.valueOf(bIPhone.getPhoneNumber())));
            treeMap.put("type", StringUtilities.encodeAttributeValue(String.valueOf(bIPhone.getPhoneType())));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

