/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDocument
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIDocument doc = null;

    public WXMLDocument(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof BIDocument;
        if (bl) {
            this.doc = (BIDocument)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.doc != null) {
            String string = this.doc.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("docPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof BIDocument) {
            BIDocument bIDocument = (BIDocument)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("docreference", StringUtilities.encodeAttributeValue(String.valueOf(bIDocument.getReference())));
            treeMap.put("type", StringUtilities.encodeAttributeValue(String.valueOf(bIDocument.getType())));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

