/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLBusinessInfoDesign
extends AbstractXMLWriter {
    private BusinessInfoDesign design = null;

    public WXMLBusinessInfoDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof BusinessInfoDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (BusinessInfoDesign)object;
        Document document = this.createDocument("design");
        Element element = document.getDocumentElement();
        element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
        Element element2 = document.createElement("ref");
        element.appendChild(element2);
        Collection collection = this.design.getStorableDesignObjects();
        Iterator iterator = collection.iterator();
        DesignObject designObject = null;
        while (iterator.hasNext()) {
            designObject = (DesignObject)iterator.next();
            this.handleDesignObject(element2, designObject);
        }
        this.design.setDirty(false);
        return document;
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean bl = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (bl) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element.appendChild(element2);
    }

    @Override
    public String getFilenameFor(Object object) {
        BusinessInfoDesign businessInfoDesign = (BusinessInfoDesign)object;
        return businessInfoDesign.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("businessinfo");
            return stringBuffer.toString();
        }
        return "businessinfo";
    }
}

