/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLParty
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLParty(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getBusinessInfoDesign().getResPartySet().createParty(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        BIResponsibleParty bIResponsibleParty = (BIResponsibleParty)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        bIResponsibleParty.setResponsibility(StringUtilities.decodeAttributeValue((String)map.get("responsibility")));
        Map map2 = this.getProperties(element, "contacts");
        Object[] objectArray = map2.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)map2.get(objectArray[i]);
            BIContact bIContact = (BIContact)bIResponsibleParty.getDesign().getBusinessInfoDesign().getContactSet().getObjectByID(string);
            if (bIContact == null) continue;
            bIResponsibleParty.addContact(bIContact);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(bIResponsibleParty.getObjectID())).append(".dmd");
        bIResponsibleParty.setFilePath(stringBuffer.toString());
        return bIResponsibleParty;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("partyPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == BIResponsibleParty.class;
    }
}

