/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLLocation
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLLocation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getBusinessInfoDesign().getLocationSet().createLocation(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        BILocation bILocation = (BILocation)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        bILocation.setLocationType((String)map.get("type"));
        bILocation.setAddress((String)map.get("address"));
        bILocation.setCity((String)map.get("city"));
        bILocation.setPostCode((String)map.get("postcode"));
        bILocation.setArea((String)map.get("area"));
        bILocation.setCountry((String)map.get("country"));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(bILocation.getObjectID())).append(".dmd");
        bILocation.setFilePath(stringBuffer.toString());
        return bILocation;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("locationPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == BILocation.class;
    }
}

