/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLContact
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLContact(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getBusinessInfoDesign().getContactSet().createContact(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        DesignObject designObject;
        String string;
        int n;
        BIContact bIContact = (BIContact)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "emails");
        Object[] objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = (BIEmail)bIContact.getDesign().getBusinessInfoDesign().getEmailSet().getObjectByID(string);
            if (designObject == null) continue;
            bIContact.addEmail((BIEmail)designObject);
        }
        map = this.getProperties(element, "locations");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = (BILocation)bIContact.getDesign().getBusinessInfoDesign().getLocationSet().getObjectByID(string);
            if (designObject == null) continue;
            bIContact.addLocation((BILocation)designObject);
        }
        map = this.getProperties(element, "phones");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = (BIPhone)bIContact.getDesign().getBusinessInfoDesign().getPhoneSet().getObjectByID(string);
            if (designObject == null) continue;
            bIContact.addPhone((BIPhone)designObject);
        }
        map = this.getProperties(element, "urls");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = (BIResourceLocator)bIContact.getDesign().getBusinessInfoDesign().getUrlSet().getObjectByID(string);
            if (designObject == null) continue;
            bIContact.addUrl((BIResourceLocator)designObject);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(bIContact.getObjectID())).append(".dmd");
        bIContact.setFilePath(stringBuffer.toString());
        return bIContact;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("contactPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == BIContact.class;
    }
}

