/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLBusinessInfoDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER = new Logger(RXMLBusinessInfoDesign.class);

    public RXMLBusinessInfoDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string));
        }
        NodeList nodeList = RXMLBusinessInfoDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttribute("role");
            String string3 = element2.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase(string2) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string3, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string3);
            if (designObject != null) {
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLBusinessInfoDesign: Read object returns null (objectID: " + string3);
        }
        designPart.setLoaded(true);
        return designPart;
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("businessinfo");
            return stringBuffer.toString();
        }
        return "businessinfo";
    }
}

