/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLTypes
extends AbstractWXMLDesignObject {
    private String[] typesRDBMSSites;

    public WXMLTypes(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof LogicalDatatype;
    }

    @Override
    public Document writeDocument(Object object) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPersistenceManager().getAppView().getDesignName();
        stringBuffer.append(string).append('/').append(this.getConfiguration().get("logtypePath"));
        return stringBuffer.toString();
    }

    public void appendTypeInfo(Element element, LogicalDatatype logicalDatatype) {
        Object[] objectArray = logicalDatatype.getDesign().getRDBMSTypeSet().toArray();
        this.typesRDBMSSites = new String[objectArray.length];
        this.setTypesRDBMSSites(objectArray);
        this.appendDesignObjectInfo(element, logicalDatatype);
    }

    private void setTypesRDBMSSites(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.typesRDBMSSites[i] = ((RDBMSType)objectArray[i]).getName();
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((LogicalDatatype)object).getFileName();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        this.appendLogicalType(element, designObject);
    }

    private void appendLogicalType(Element element, DesignObject designObject) {
        if (designObject instanceof LogicalDatatype) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)designObject;
            Element element2 = element.getOwnerDocument().createElement("logicaltype");
            element2.setAttribute("name", StringUtilities.encodeAttributeValue(logicalDatatype.getName()));
            element2.setAttribute("objectid", StringUtilities.encodeAttributeValue(logicalDatatype.getObjectID()));
            if (logicalDatatype.getName().equalsIgnoreCase("UNKNOWN")) {
                element2.setAttribute("default", "true");
            }
            element.appendChild(element2);
            this.appendMapping(element2, logicalDatatype);
        }
    }

    private void appendMapping(Element element, LogicalDatatype logicalDatatype) {
        Map map = logicalDatatype.getToPhysical();
        Map map2 = logicalDatatype.getDefaultValues();
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            Object object;
            String string = (String)map.get(this.typesRDBMSSites[i]);
            Element element2 = element.getOwnerDocument().createElement("mapping");
            element2.setAttribute("rdbms", this.typesRDBMSSites[i]);
            TreeMap treeMap = (TreeMap)map2.get(this.typesRDBMSSites[i]);
            if (treeMap != null) {
                String string2;
                String string3;
                object = (String)treeMap.get("precision_default_value");
                if (object != null && ((String)object).trim().length() > 0) {
                    element2.setAttribute("precision_default_value", (String)treeMap.get("precision_default_value"));
                }
                if ((string3 = (String)treeMap.get("scale_default_value")) != null && string3.trim().length() > 0) {
                    element2.setAttribute("scale_default_value", (String)treeMap.get("scale_default_value"));
                }
                if ((string2 = (String)treeMap.get("size_default_value")) != null && string2.trim().length() > 0) {
                    element2.setAttribute("size_default_value", (String)treeMap.get("size_default_value"));
                }
            }
            object = element.getOwnerDocument().createTextNode(string);
            element2.appendChild((Node)object);
            element.appendChild(element2);
        }
    }
}

